/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond;

import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.plantuml.activitydiagram3.PositionedNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileIfNude;
import net.sourceforge.plantuml.klimt.LineBreakStrategy;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Sheet;
import net.sourceforge.plantuml.klimt.creole.SheetBlock1;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.skin.AlignmentParam;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.image.Opale;

public class FtileIfWithDiamonds
extends FtileIfNude {
    private static final double SUPP_WIDTH = 20.0;
    protected final Ftile diamond1;
    protected final Ftile diamond2;
    private TextBlock opaleLeft = TextBlockUtils.EMPTY_TEXT_BLOCK;
    private TextBlock opaleRight = TextBlockUtils.EMPTY_TEXT_BLOCK;

    public FtileIfWithDiamonds(Ftile diamond1, Ftile tile1, Ftile tile2, Ftile diamond2, Swimlane in, StringBounder stringBounder, Collection<PositionedNote> notes) {
        super(tile1, tile2, in);
        this.diamond1 = diamond1;
        this.diamond2 = diamond2;
        for (PositionedNote first : notes) {
            if (first.getNotePosition() == NotePosition.LEFT) {
                if (this.opaleLeft != TextBlockUtils.EMPTY_TEXT_BLOCK) continue;
                this.opaleLeft = FtileIfWithDiamonds.createOpale(first, this.skinParam());
                double pos1 = this.getTranslateDiamond1(stringBounder).getDx();
                XDimension2D dimOpale = this.opaleLeft.calculateDimension(stringBounder);
                double opaleWith = dimOpale.getWidth();
                if (opaleWith > pos1) {
                    this.xDeltaNote = opaleWith - pos1;
                }
                this.yDeltaNote = Math.max(this.yDeltaNote, dimOpale.getHeight());
            } else if (first.getNotePosition() == NotePosition.RIGHT) {
                double pos2;
                if (this.opaleRight != TextBlockUtils.EMPTY_TEXT_BLOCK) continue;
                this.opaleRight = FtileIfWithDiamonds.createOpale(first, this.skinParam());
                XDimension2D dimOpale = this.opaleRight.calculateDimension(stringBounder);
                double pos1 = this.getTranslateDiamond1(stringBounder).getDx() + diamond1.calculateDimension(stringBounder).getWidth() + dimOpale.getWidth();
                if (pos1 > (pos2 = this.calculateDimensionInternalSlow(stringBounder).getWidth())) {
                    this.suppWidthNode = pos1 - pos2;
                }
                this.yDeltaNote = Math.max(this.yDeltaNote, dimOpale.getHeight());
            }
            this.clearCacheDimensionInternal();
        }
    }

    public static Opale createOpale(PositionedNote first, ISkinParam skinParam) {
        Style style = FtileIfWithDiamonds.getStyleSignature().getMergedStyle(skinParam.getCurrentStyleBuilder()).eventuallyOverride(first.getColors());
        HColor noteBackgroundColor = style.value(PName.BackGroundColor).asColor(skinParam.getIHtmlColorSet());
        HColor borderColor = style.value(PName.LineColor).asColor(skinParam.getIHtmlColorSet());
        FontConfiguration fc = style.getFontConfiguration(skinParam.getIHtmlColorSet());
        double shadowing = style.value(PName.Shadowing).asDouble();
        LineBreakStrategy wrapWidth = style.wrapWidth();
        UStroke stroke = style.getStroke();
        HorizontalAlignment align = skinParam.getHorizontalAlignment(AlignmentParam.noteTextAlignment, null, false, null);
        Sheet sheet = skinParam.sheet(fc, align, CreoleMode.FULL).createSheet(first.getDisplay());
        SheetBlock1 tmp1 = new SheetBlock1(sheet, wrapWidth, skinParam.getPadding());
        return new Opale(shadowing, borderColor, noteBackgroundColor, tmp1, false, stroke);
    }

    private static StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.note);
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return Arrays.asList(this.diamond1, this.diamond2, this.tile1, this.tile2);
    }

    protected int getYdelta1a(StringBounder stringBounder) {
        if (this.getSwimlanes().size() > 1) {
            return 20;
        }
        return 10;
    }

    protected int getYdelta1b(StringBounder stringBounder) {
        if (this.getSwimlanes().size() > 1) {
            return 10;
        }
        return this.hasTwoBranches(stringBounder) ? 6 : 0;
    }

    protected double getYdeltaForLabels(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    protected double widthInner(StringBounder stringBounder) {
        FtileGeometry dim1 = this.diamond1.calculateDimension(stringBounder);
        return Math.max(super.widthInner(stringBounder), dim1.getWidth() + 20.0);
    }

    @Override
    protected FtileGeometry calculateDimensionInternalSlow(StringBounder stringBounder) {
        FtileGeometry dim1 = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry dim2 = this.diamond2.calculateDimension(stringBounder);
        FtileGeometry dimNude = super.calculateDimensionInternalSlow(stringBounder);
        FtileGeometry all = dim1.appendBottom(dimNude).appendBottom(dim2);
        double deltaHeight = (double)(this.getYdelta1a(stringBounder) + this.getYdelta1b(stringBounder)) + this.getYdeltaForLabels(stringBounder);
        FtileGeometry result = all.addDim(0.0, deltaHeight).incInY(this.yDeltaNote);
        return result;
    }

    @Override
    public void drawU(UGraphic ug) {
        double xOpale;
        StringBounder stringBounder = ug.getStringBounder();
        if (!TextBlockUtils.isEmpty(this.opaleLeft, stringBounder)) {
            xOpale = this.getTranslateDiamond1(stringBounder).getDx() - this.opaleLeft.calculateDimension(stringBounder).getWidth();
            this.opaleLeft.drawU(ug.apply(UTranslate.dx(xOpale)));
        }
        if (!TextBlockUtils.isEmpty(this.opaleRight, stringBounder)) {
            xOpale = this.getTranslateDiamond1(stringBounder).getDx() + this.diamond1.calculateDimension(stringBounder).getWidth();
            this.opaleRight.drawU(ug.apply(UTranslate.dx(xOpale)));
        }
        ug.apply(this.getTranslateDiamond1(stringBounder)).draw(this.diamond1);
        super.drawU(ug);
        ug.apply(this.getTranslateDiamond2(stringBounder)).draw(this.diamond2);
    }

    @Override
    protected UTranslate getTranslateBranch1(StringBounder stringBounder) {
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        return super.getTranslateBranch1(stringBounder).compose(UTranslate.dy(dimDiamond1.getHeight() + (double)this.getYdelta1a(stringBounder)));
    }

    @Override
    protected UTranslate getTranslateBranch2(StringBounder stringBounder) {
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        return super.getTranslateBranch2(stringBounder).compose(UTranslate.dy(dimDiamond1.getHeight() + (double)this.getYdelta1a(stringBounder)));
    }

    protected UTranslate getTranslateDiamond1(StringBounder stringBounder) {
        double y1 = this.yDeltaNote;
        FtileGeometry dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        double x1 = dimTotal.getLeft() - dimDiamond1.getLeft();
        return new UTranslate(x1, y1);
    }

    protected UTranslate getTranslateDiamond2(StringBounder stringBounder) {
        FtileGeometry dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry dimDiamond2 = this.diamond2.calculateDimension(stringBounder);
        double x2 = dimTotal.getLeft() - dimDiamond2.getWidth() / 2.0;
        double y2 = dimTotal.getHeight() - dimDiamond2.getHeight();
        return new UTranslate(x2, y2);
    }

    public double computeMarginNeedForBranchLabe1(StringBounder stringBounder, XDimension2D label1) {
        double dxDiamond;
        double widthLabelBranch1 = label1.getWidth();
        double diff = widthLabelBranch1 - (dxDiamond = this.getTranslateDiamond1(stringBounder).getDx());
        if (diff > 0.0) {
            return diff;
        }
        return 0.0;
    }

    public double computeMarginNeedForBranchLabe2(StringBounder stringBounder, XDimension2D label2) {
        double widthLabelBranch2 = label2.getWidth();
        double theoricalEndNeeded = this.getTranslateDiamond1(stringBounder).getDx() + this.diamond1.calculateDimension(stringBounder).getWidth() + widthLabelBranch2;
        double diff = theoricalEndNeeded - this.calculateDimension(stringBounder).getWidth();
        if (diff > 0.0) {
            return diff;
        }
        return 0.0;
    }

    public double computeVerticalMarginNeedForBranchs(StringBounder stringBounder, XDimension2D label1, XDimension2D label2) {
        FtileGeometry dimDiamond1;
        double dyDiamond;
        double heightLabels = Math.max(label1.getHeight(), label2.getHeight());
        double diff = heightLabels - (dyDiamond = (dimDiamond1 = this.diamond1.calculateDimension(stringBounder)).getHeight());
        if (diff > 0.0) {
            return diff;
        }
        return 0.0;
    }
}

