/*
 * Decompiled with CFR 0.152.
 */
package com.plantuml.api.cheerpj.v1;

import com.plantuml.api.cheerpj.JsonResult;
import com.plantuml.api.cheerpj.SvgOutputStream;
import com.plantuml.api.cheerpj.Utils;
import com.plantuml.api.cheerpj.WasmLog;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.BlockUmlBuilder;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.error.PSystemError;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.preproc.Defines;

public class Svg {
    public static Object convert(String mode, String text) {
        long start;
        WasmLog.start = start = System.currentTimeMillis();
        WasmLog.log("Starting processing");
        try {
            FileFormatOption format = new FileFormatOption(FileFormat.SVG);
            if ("dark".equalsIgnoreCase(mode)) {
                format = format.withColorMapper(ColorMapper.DARK_MODE);
            }
            text = Utils.cleanText(text);
            BlockUmlBuilder builder = new BlockUmlBuilder(Collections.emptyList(), StandardCharsets.UTF_8, Defines.createEmpty(), (Reader)new StringReader(text), null, "string");
            List<BlockUml> blocks = builder.getBlockUmls();
            if (blocks.size() == 0) {
                return JsonResult.noDataFound(start);
            }
            Diagram system = blocks.get(0).getDiagram();
            if (system instanceof PSystemError) {
                ErrorUml error = ((PSystemError)system).getFirstError();
                WasmLog.log("[" + error.getPosition() + "] " + error.getError());
                return JsonResult.fromError(start, (PSystemError)system);
            }
            WasmLog.log("...processing...");
            SvgOutputStream svgos = new SvgOutputStream();
            WasmLog.log("...loading data...");
            ImageData imageData = system.exportDiagram(svgos, 0, format);
            WasmLog.log("Done!");
            svgos.close();
            String svg = svgos.toString();
            return svg;
        }
        catch (Throwable t) {
            WasmLog.log("Fatal error " + t);
            return JsonResult.fromCrash(start, t);
        }
    }
}

