/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.security.authentication.oauth;

import java.util.Arrays;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.security.SURL;
import net.sourceforge.plantuml.security.authentication.SecurityAuthentication;
import net.sourceforge.plantuml.security.authentication.SecurityCredentials;
import net.sourceforge.plantuml.security.authentication.basicauth.BasicAuthAuthorizeManager;
import net.sourceforge.plantuml.security.authentication.oauth.AbstractOAuth2AccessAuthorizeManager;

public class OAuth2ResourceOwnerAccessAuthorizeManager
extends AbstractOAuth2AccessAuthorizeManager {
    private final BasicAuthAuthorizeManager basicAuthManager = new BasicAuthAuthorizeManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecurityAuthentication create(SecurityCredentials credentials) {
        String grantType = credentials.getPropertyStr("grantType");
        String requestScope = credentials.getPropertyStr("scope");
        String accessTokenUri = credentials.getPropertyStr("accessTokenUri");
        String tokenType = credentials.getPropertyStr("tokenType");
        String username = credentials.getPropertyStr("resourceOwner.identifier");
        char[] password = credentials.getPropertyChars("resourceOwner.secret");
        try {
            SURL tokenService = SURL.create(accessTokenUri);
            StringBuilder content = new StringBuilder().append("grant_type=").append(this.urlEncode(grantType));
            if (StringUtils.isNotEmpty(requestScope)) {
                content.append("&scope=").append(this.urlEncode(requestScope));
            }
            SecurityAuthentication basicAuth = this.basicAuthManager.create(SecurityCredentials.basicAuth(credentials.getIdentifier(), credentials.getSecret()));
            content.append("&username=").append(this.urlEncode(username)).append("&password=").append(this.urlEncode(new String(password)));
            SecurityAuthentication securityAuthentication = this.requestAndCreateAuthFromResponse(credentials.getProxy(), grantType, tokenType, tokenService, content.toString(), basicAuth);
            return securityAuthentication;
        }
        finally {
            if (password != null && password.length > 0) {
                Arrays.fill(password, '*');
            }
        }
    }
}

