/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag.core;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.decoration.symbol.USymbols;
import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.nwdiag.core.Network;
import net.sourceforge.plantuml.nwdiag.next.NBar;
import net.sourceforge.plantuml.nwdiag.next.NServerDraw;
import net.sourceforge.plantuml.skin.ActorStyle;
import net.sourceforge.plantuml.skin.ComponentStyle;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.PackageStyle;

public class NServer {
    private final Map<Network, String> connections = new LinkedHashMap<Network, String>();
    private USymbol shape = USymbols.RECTANGLE;
    private final String name;
    private String description;
    private String backcolor;
    private final NBar bar;
    private final ISkinParam skinParam;
    private String declaredAddress;
    private boolean printFirstLink = true;

    public void doNotPrintFirstLink() {
        this.printFirstLink = false;
    }

    public void connectMeIfAlone(Network network) {
        if (this.isAlone()) {
            this.connectTo(network, "");
            if (!network.isVisible()) {
                this.doNotPrintFirstLink();
            }
        }
    }

    public boolean isAlone() {
        return this.connections.size() == 0;
    }

    public String someAddress() {
        if (this.connections.size() > 0 && this.connections.values().iterator().next().length() > 0) {
            return this.connections.values().iterator().next();
        }
        if (this.declaredAddress != null) {
            return this.declaredAddress;
        }
        return "";
    }

    public Network someNetwork() {
        if (this.connections.size() > 0) {
            return this.connections.keySet().iterator().next();
        }
        return null;
    }

    public void blankSomeAddress() {
        if (this.connections.size() > 0) {
            Network it = this.connections.keySet().iterator().next();
            this.connections.put(it, "");
        }
    }

    public void learnThisAddress(String address) {
        if (address == null) {
            address = "";
        }
        for (Map.Entry<Network, String> ent : this.connections.entrySet()) {
            if (ent.getValue().length() != 0) continue;
            this.connections.put(ent.getKey(), address);
            return;
        }
    }

    public final boolean printFirstLink() {
        return this.printFirstLink;
    }

    public Network getMainNetworkNext() {
        return this.connections.keySet().iterator().next();
    }

    public String getAdress(Network network) {
        return this.connections.get(network);
    }

    public TextBlock toTextBlock(SName sname, String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        s = s.replace(", ", "\\n");
        return Display.getWithNewlines(s).create(this.getFontConfiguration(sname), HorizontalAlignment.LEFT, this.skinParam);
    }

    private StyleSignatureBasic getStyleDefinition(SName sname) {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.nwdiagDiagram, sname);
    }

    private FontConfiguration getFontConfiguration(SName sname) {
        StyleBuilder styleBuilder = this.skinParam.getCurrentStyleBuilder();
        Style style = this.getStyleDefinition(sname).getMergedStyle(styleBuilder);
        return style.getFontConfiguration(this.skinParam.getIHtmlColorSet());
    }

    public NServerDraw getDraw(double topMargin, Map<Network, String> conns, List<Network> networks, ISkinParam skinParam) {
        StyleBuilder styleBuilder = skinParam.getCurrentStyleBuilder();
        Fashion symbolContext = this.getStyleDefinition(SName.server).getMergedStyle(styleBuilder).getSymbolContext(skinParam.getIHtmlColorSet());
        if (this.backcolor != null) {
            try {
                HColor back = skinParam.getIHtmlColorSet().getColor(this.backcolor);
                symbolContext = symbolContext.withBackColor(back);
            }
            catch (NoSuchColorException back) {
                // empty catch block
            }
        }
        TextBlock desc = this.toTextBlock(SName.server, this.getDescription());
        TextBlock box = this.getShape().asSmall(TextBlockUtils.empty(0.0, 0.0), desc, TextBlockUtils.empty(0.0, 0.0), symbolContext, HorizontalAlignment.CENTER);
        return new NServerDraw(this, box, conns, networks, topMargin);
    }

    public void connectTo(Network network, String address) {
        if (network == null) {
            throw new IllegalArgumentException();
        }
        if (address == null) {
            address = "";
        }
        if (address.length() == 0 && this.connections.containsKey(network)) {
            return;
        }
        this.connections.put(network, address);
        if (this.bar.getStart() == null) {
            this.bar.addStage(network.getNstage());
        } else if (this.getMainNetworkNext() != network) {
            this.bar.addStage(network.getUp());
        }
    }

    public void updateProperties(Map<String, String> props) {
        USymbol shapeFromString;
        String shape;
        if (props.get("description") != null) {
            this.description = props.get("description");
        }
        if (props.get("color") != null) {
            this.backcolor = props.get("color");
        }
        if (props.get("address") != null) {
            this.declaredAddress = props.get("address");
        }
        if ((shape = props.get("shape")) != null && (shapeFromString = USymbols.fromString(shape, ActorStyle.STICKMAN, ComponentStyle.RECTANGLE, PackageStyle.RECTANGLE)) != null) {
            this.shape = shapeFromString;
        }
    }

    public final String toString() {
        return this.name;
    }

    public static NServer create(String name, ISkinParam skinParam) {
        return new NServer(name, new NBar(), skinParam);
    }

    public NServer(String name, NBar bar, ISkinParam skinParam) {
        this.description = name;
        this.name = name;
        this.bar = bar;
        this.skinParam = skinParam;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getName() {
        return this.name;
    }

    public final USymbol getShape() {
        return this.shape;
    }

    public final NBar getBar() {
        return this.bar;
    }

    public final ISkinParam getSkinParam() {
        return this.skinParam;
    }
}

