/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;

class FtileForkInner
extends AbstractFtile {
    private final List<Ftile> forks = new ArrayList<Ftile>();

    public FtileForkInner(List<Ftile> forks) {
        super(forks.get(0).skinParam());
        for (Ftile ftile : forks) {
            this.forks.add(ftile);
        }
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return Collections.unmodifiableCollection(this.forks);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.forks.get(0).getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return FtileForkInner.mergeSwimlanes(this.forks);
    }

    public static Set<Swimlane> mergeSwimlanes(List<Ftile> tiles) {
        HashSet<Swimlane> result = new HashSet<Swimlane>();
        for (Ftile tile : tiles) {
            result.addAll(tile.getSwimlanes());
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        double xpos = 0.0;
        for (Ftile ftile : this.forks) {
            ug.apply(UTranslate.dx(xpos)).draw(ftile);
            FtileGeometry dim = ftile.calculateDimension(stringBounder);
            xpos += ((XDimension2D)dim).getWidth();
        }
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        double height = 0.0;
        double width = 0.0;
        for (Ftile ftile : this.forks) {
            FtileGeometry dim = ftile.calculateDimension(stringBounder);
            width += ((XDimension2D)dim).getWidth();
            if (!(((XDimension2D)dim).getHeight() > height)) continue;
            height = ((XDimension2D)dim).getHeight();
        }
        XDimension2D dimTotal = new XDimension2D(width, height);
        return new FtileGeometry(dimTotal, dimTotal.getWidth() / 2.0, 0.0, dimTotal.getHeight());
    }

    @Override
    public UTranslate getTranslateFor(Ftile searched, StringBounder stringBounder) {
        double xpos = 0.0;
        for (Ftile ftile : this.forks) {
            if (ftile == searched) {
                return UTranslate.dx(xpos);
            }
            FtileGeometry dim = ftile.calculateDimension(stringBounder);
            xpos += ((XDimension2D)dim).getWidth();
        }
        throw new IllegalArgumentException();
    }
}

