/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.util.Arrays;
import java.util.List;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.JavaEnvUtils;

class LanguageLevel {
    private static final String MIN_LEVEL = "6";
    private static final List<String> UNSUPPORTED_LEVELS = Arrays.asList("1.1", "1.2", "1.3", "1.4", "1.5", "5");

    LanguageLevel() {
    }

    static boolean isDebianBuild() {
        return System.getenv("DEB_BUILD_ARCH") != null;
    }

    static boolean isPreJava9() {
        return JavaEnvUtils.isJavaVersion("1.5") || JavaEnvUtils.isJavaVersion("1.6") || JavaEnvUtils.isJavaVersion("1.7") || JavaEnvUtils.isJavaVersion("1.8");
    }

    static String adjust(String level, String location, Task logger) {
        if (level == null) {
            return level;
        }
        if (!LanguageLevel.isDebianBuild()) {
            return level;
        }
        if (LanguageLevel.isPreJava9()) {
            return level;
        }
        if (!UNSUPPORTED_LEVELS.contains(level)) {
            return level;
        }
        if (logger != null) {
            logger.log("Using " + location + " " + level + " is no longer supported, switching to " + MIN_LEVEL, 1);
        }
        return MIN_LEVEL;
    }
}

