/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.xmlsc;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.statediagram.StateDiagram;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.text.Guillemet;
import net.sourceforge.plantuml.xml.XmlFactories;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ScxmlStateDiagramStandard {
    private final StateDiagram diagram;
    private final Document document;

    public ScxmlStateDiagramStandard(StateDiagram diagram) throws ParserConfigurationException {
        this.diagram = diagram;
        DocumentBuilder builder = XmlFactories.newDocumentBuilder();
        this.document = builder.newDocument();
        this.document.setXmlVersion("1.0");
        this.document.setXmlStandalone(true);
        Element scxml = this.document.createElement("scxml");
        scxml.setAttribute("xmlns", "http://www.w3.org/2005/07/scxml");
        scxml.setAttribute("version", "1.0");
        String initial = this.getInitial();
        if (initial != null) {
            scxml.setAttribute("initial", initial);
        }
        this.document.appendChild(scxml);
        for (Entity ent : diagram.getEntityFactory().leafs()) {
            if (!ent.getParentContainer().isRoot()) continue;
            scxml.appendChild(this.createState(ent));
        }
        for (Entity ent : diagram.getEntityFactory().groups()) {
            if (!ent.getParentContainer().isRoot()) continue;
            this.exportGroup(scxml, ent);
        }
    }

    private Element exportGroup(Element dest, Entity ent) {
        Element gr = this.createGroup(ent);
        dest.appendChild(gr);
        for (Entity leaf : ent.leafs()) {
            gr.appendChild(this.createState(leaf));
        }
        for (Entity child : ent.groups()) {
            this.exportGroup(gr, child);
        }
        return gr;
    }

    private String getInitial() {
        for (Entity ent : this.diagram.getEntityFactory().leafs()) {
            if (ent.getLeafType() != LeafType.CIRCLE_START) continue;
            return this.getId(ent);
        }
        return null;
    }

    private Element createGroup(Entity entity) {
        return this.createState(entity);
    }

    private Element createState(Entity entity) {
        LeafType type = entity.getLeafType();
        Element state = this.document.createElement("state");
        if (type == LeafType.NOTE) {
            state.setAttribute("stereotype", "note");
            state.setAttribute("id", entity.getName());
            Display display = entity.getDisplay();
            StringBuilder sb = new StringBuilder();
            for (CharSequence s : display) {
                sb.append(s);
                sb.append("\n");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            Comment comment = this.document.createComment(sb.toString());
            state.appendChild(comment);
        } else {
            state.setAttribute("id", this.getId(entity));
            Stereotype stereotype = entity.getStereotype();
            if (stereotype != null) {
                state.setAttribute("stereotype", stereotype.getLabels(Guillemet.NONE).get(0));
            }
            for (Link link : this.diagram.getLinks()) {
                if (link.getEntity1() != entity) continue;
                this.addLink(state, link);
            }
        }
        return state;
    }

    private void addLink(Element state, Link link) {
        Element transition = this.document.createElement("transition");
        Display label = link.getLabel();
        if (!Display.isNull(label)) {
            String event = label.get(0).toString();
            transition.setAttribute("event", event);
        }
        transition.setAttribute("target", this.getId(link.getEntity2()));
        state.appendChild(transition);
    }

    private String getId(Entity entity) {
        return entity.getName().replaceAll("\\*", "");
    }

    public void transformerXml(OutputStream os) throws TransformerException, ParserConfigurationException {
        DOMSource source = new DOMSource(this.document);
        StreamResult resultat = new StreamResult(os);
        Transformer transformer = XmlFactories.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
        transformer.transform(source, resultat);
    }
}

