/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.decoration;

import java.util.Objects;
import net.sourceforge.plantuml.abel.LinkStrategy;
import net.sourceforge.plantuml.decoration.LinkDecor;
import net.sourceforge.plantuml.decoration.LinkMiddleDecor;
import net.sourceforge.plantuml.decoration.LinkStyle;
import net.sourceforge.plantuml.klimt.UStroke;

public class LinkType {
    private final LinkDecor decor1;
    private final LinkStyle linkStyle;
    private final LinkDecor decor2;
    private final LinkMiddleDecor middleDecor;

    public boolean isDoubleDecorated() {
        return this.decor1 != LinkDecor.NONE && this.decor2 != LinkDecor.NONE;
    }

    public boolean looksLikeRevertedForSvg() {
        return this.decor1 == LinkDecor.NONE && this.decor2 != LinkDecor.NONE;
    }

    public boolean looksLikeNoDecorAtAllSvg() {
        if (this.decor1 == LinkDecor.NONE && this.decor2 == LinkDecor.NONE) {
            return true;
        }
        return this.decor1 != LinkDecor.NONE && this.decor2 != LinkDecor.NONE;
    }

    public LinkType(LinkDecor decor1, LinkDecor decor2) {
        this(decor1, decor2, LinkMiddleDecor.NONE, LinkStyle.NORMAL());
    }

    private LinkType(LinkDecor decor1, LinkDecor decor2, LinkMiddleDecor middleDecor, LinkStyle style) {
        this.decor1 = decor1;
        this.decor2 = decor2;
        this.middleDecor = middleDecor;
        this.linkStyle = Objects.requireNonNull(style);
    }

    public LinkType withoutDecors1() {
        return new LinkType(LinkDecor.NONE, this.decor2, this.middleDecor, this.linkStyle);
    }

    public LinkType withoutDecors2() {
        return new LinkType(this.decor1, LinkDecor.NONE, this.middleDecor, this.linkStyle);
    }

    public String toString() {
        return (Object)((Object)this.decor1) + "-" + this.linkStyle + "-" + (Object)((Object)this.decor2);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        LinkType other = (LinkType)obj;
        return this.decor1 == other.decor1 && this.decor2 == other.decor2 && this.linkStyle == other.linkStyle;
    }

    public boolean isInvisible() {
        return this.linkStyle.isInvisible();
    }

    public LinkType goDashed() {
        return new LinkType(this.decor1, this.decor2, this.middleDecor, LinkStyle.DASHED());
    }

    public LinkType goDotted() {
        return new LinkType(this.decor1, this.decor2, this.middleDecor, LinkStyle.DOTTED());
    }

    public LinkType goThickness(double thickness) {
        return new LinkType(this.decor1, this.decor2, this.middleDecor, this.linkStyle.goThickness(thickness));
    }

    public LinkType goBold() {
        return new LinkType(this.decor1, this.decor2, this.middleDecor, LinkStyle.BOLD());
    }

    public LinkType getInversed() {
        return new LinkType(this.decor2, this.decor1, this.middleDecor.getInversed(), this.linkStyle);
    }

    public LinkType withMiddleCircle() {
        return new LinkType(this.decor1, this.decor2, LinkMiddleDecor.CIRCLE, this.linkStyle);
    }

    public LinkType withMiddleCircleCircled() {
        return new LinkType(this.decor1, this.decor2, LinkMiddleDecor.CIRCLE_CIRCLED, this.linkStyle);
    }

    public LinkType withMiddleCircleCircled1() {
        return new LinkType(this.decor1, this.decor2, LinkMiddleDecor.CIRCLE_CIRCLED1, this.linkStyle);
    }

    public LinkType withMiddleCircleCircled2() {
        return new LinkType(this.decor1, this.decor2, LinkMiddleDecor.CIRCLE_CIRCLED2, this.linkStyle);
    }

    public LinkType getInvisible() {
        return new LinkType(this.decor1, this.decor2, this.middleDecor, LinkStyle.INVISIBLE());
    }

    public String getSpecificDecorationSvek(LinkStrategy linkStrategy) {
        boolean isEmpty2;
        if (linkStrategy == LinkStrategy.SIMPLIER) {
            return "arrowtail=none,arrowhead=none";
        }
        StringBuilder sb = new StringBuilder();
        boolean isEmpty1 = this.decor1 == LinkDecor.NONE;
        boolean bl = isEmpty2 = this.decor2 == LinkDecor.NONE;
        if (isEmpty1 && isEmpty2) {
            sb.append("arrowtail=none");
            sb.append(",arrowhead=none");
        } else if (!isEmpty1 && !isEmpty2) {
            sb.append("dir=both,");
            sb.append("arrowtail=empty");
            sb.append(",arrowhead=empty");
        } else if (isEmpty1 && !isEmpty2) {
            sb.append("arrowtail=empty");
            sb.append(",arrowhead=none");
            sb.append(",dir=back");
        }
        double arrowsize = Math.max(this.decor1.getArrowSize(), this.decor2.getArrowSize());
        if (arrowsize > 0.0) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("arrowsize=" + arrowsize);
        }
        return sb.toString();
    }

    public final LinkDecor getDecor1() {
        return this.decor1;
    }

    public final LinkStyle getStyle() {
        return this.linkStyle;
    }

    public final LinkDecor getDecor2() {
        return this.decor2;
    }

    private boolean isExtendsOrAggregationOrCompositionOrPlus() {
        return this.isExtends() || this.isAggregationOrComposition() || this.isPlus() || this.isOf(LinkDecor.DEFINEDBY) || this.isOf(LinkDecor.REDEFINES);
    }

    private boolean isExtendsOrPlus() {
        return this.isExtends() || this.isPlus() || this.isOf(LinkDecor.DEFINEDBY) || this.isOf(LinkDecor.REDEFINES);
    }

    private boolean isOf(LinkDecor ld) {
        return this.decor1 == ld || this.decor2 == ld;
    }

    public boolean isExtends() {
        return this.decor1 == LinkDecor.EXTENDS || this.decor2 == LinkDecor.EXTENDS;
    }

    private boolean isPlus() {
        return this.decor1 == LinkDecor.PLUS || this.decor2 == LinkDecor.PLUS;
    }

    private boolean isAggregationOrComposition() {
        return this.decor1 == LinkDecor.AGREGATION || this.decor2 == LinkDecor.AGREGATION || this.decor1 == LinkDecor.COMPOSITION || this.decor2 == LinkDecor.COMPOSITION;
    }

    public LinkType getPart1() {
        return new LinkType(this.decor1, LinkDecor.NONE, this.middleDecor, this.linkStyle);
    }

    public LinkType getPart2() {
        return new LinkType(LinkDecor.NONE, this.decor2, this.middleDecor, this.linkStyle);
    }

    public UStroke getStroke3(UStroke defaultThickness) {
        if (this.linkStyle.isThicknessOverrided()) {
            return this.linkStyle.getStroke3();
        }
        if (defaultThickness == null) {
            return this.linkStyle.getStroke3();
        }
        if (defaultThickness.getDashVisible() == 0.0 && defaultThickness.getDashSpace() == 0.0) {
            return this.linkStyle.goThickness(defaultThickness.getThickness()).getStroke3();
        }
        return defaultThickness;
    }

    public LinkMiddleDecor getMiddleDecor() {
        return this.middleDecor;
    }

    public LinkType withLollipopInterfaceEye2() {
        return new LinkType(LinkDecor.NONE, this.decor2, this.middleDecor, this.linkStyle);
    }

    public LinkType withLollipopInterfaceEye1() {
        return new LinkType(this.decor1, LinkDecor.NONE, this.middleDecor, this.linkStyle);
    }
}

