/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.regex;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.MyPattern;
import net.sourceforge.plantuml.regex.RegexPartialMatch;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.text.FoxSignature;
import net.sourceforge.plantuml.text.StringLocated;

public class RegexLeaf
implements IRegex {
    private static final RegexLeaf END = new RegexLeaf("$");
    private static final RegexLeaf START = new RegexLeaf("^");
    private final String pattern;
    private final String name;
    private int count = -1;
    private static final Pattern p1 = Pattern.compile("^\\(?((?:[-0A-Za-z_!:@;/=,\" ][?+*]?|\\\\[b$(){}<>|*.+^\\[\\]][?+*]?|\\.\\*|\\.\\+)+)(?:\\)\\+|\\))?$");
    private static final Pattern p2 = Pattern.compile("^\\([-?a-z ]+(\\|[-?a-z ]+)+\\)$");
    private static final Pattern p3 = Pattern.compile("^\\(?\\[[-=.~]+\\]\\+\\)?$");

    public RegexLeaf(String regex) {
        this(null, regex);
    }

    public RegexLeaf(String name, String regex) {
        this.pattern = regex;
        this.name = name;
    }

    public static RegexLeaf spaceZeroOrMore() {
        return new RegexLeaf("[%s]*");
    }

    public static RegexLeaf spaceOneOrMore() {
        return new RegexLeaf("[%s]+");
    }

    public static RegexLeaf start() {
        return START;
    }

    public static RegexLeaf end() {
        return END;
    }

    public String toString() {
        return super.toString() + " " + this.name + " " + this.pattern;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public int count() {
        if (this.count == -1) {
            this.count = MyPattern.cmpile(this.pattern).matcher("").groupCount();
        }
        return this.count;
    }

    @Override
    public Map<String, RegexPartialMatch> createPartialMatch(Iterator<String> it) {
        RegexPartialMatch m = new RegexPartialMatch(this.name);
        for (int i = 0; i < this.count(); ++i) {
            String group = it.next();
            m.add(group);
        }
        if (this.name == null) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(this.name, m);
    }

    @Override
    public boolean match(StringLocated full) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RegexResult matcher(String full) {
        throw new UnsupportedOperationException();
    }

    private static long getSignatureP2(String s) {
        long result = -1L;
        StringTokenizer st = new StringTokenizer(s, "()|");
        while (st.hasMoreTokens()) {
            String val = st.nextToken();
            result &= FoxSignature.getFoxSignatureFromRegex(val);
        }
        return result;
    }

    public long getFoxSignature() {
        if (this.pattern.equals("[%s]+")) {
            return FoxSignature.getSpecialSpaces();
        }
        if (this.pattern.equals("[%s]*")) {
            return 0L;
        }
        String pattern2 = this.pattern.replaceAll("\\[%s\\][+*?]?|\\(\\[([^\\\\\\[\\]])+\\]\\)[+*?]?", "");
        Matcher m1 = p1.matcher(pattern2);
        if (m1.matches()) {
            return FoxSignature.getFoxSignatureFromRegex(m1.group(1));
        }
        Matcher m2 = p2.matcher(pattern2);
        if (m2.matches()) {
            return RegexLeaf.getSignatureP2(pattern2);
        }
        Matcher m3 = p3.matcher(pattern2);
        if (m3.matches()) {
            return FoxSignature.getSpecial1();
        }
        return 0L;
    }
}

