/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.creole.Command;
import net.sourceforge.plantuml.creole.StripeSimple;

public class CommandCreoleUrl
implements Command {
    private final Pattern2 pattern;
    private final ISkinSimple skinParam;

    public static Command create(ISkinSimple skinParam) {
        return new CommandCreoleUrl(skinParam, "^(" + UrlBuilder.getRegexp() + ")");
    }

    private CommandCreoleUrl(ISkinSimple skinParam, String p) {
        this.pattern = MyPattern.cmpile(p);
        this.skinParam = skinParam;
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m = this.pattern.matcher(line);
        if (!m.find()) {
            return 0;
        }
        return m.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m = this.pattern.matcher(line);
        if (!m.find()) {
            throw new IllegalStateException();
        }
        UrlBuilder urlBuilder = new UrlBuilder(this.skinParam.getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
        Url url = urlBuilder.getUrl(m.group(1));
        stripe.addUrl(url);
        return line.substring(m.group(1).length());
    }
}

