/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.preproc.FileWithSuffix;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.ReadLineSimple;
import net.sourceforge.plantuml.preproc.UncommentReadLine;
import net.sourceforge.plantuml.utils.StartUtils;

public class StartDiagramExtractReader
implements ReadLine {
    private final ReadLine raw;
    private boolean finished = false;

    public static StartDiagramExtractReader build(FileWithSuffix f2, CharSequence2 s, String charset) {
        return new StartDiagramExtractReader(StartDiagramExtractReader.getReadLine(f2, s, charset), f2.getSuffix());
    }

    public static StartDiagramExtractReader build(URL url, CharSequence2 s, String uid, String charset) {
        return new StartDiagramExtractReader(StartDiagramExtractReader.getReadLine(url, s, charset), uid);
    }

    public static StartDiagramExtractReader build(InputStream is, CharSequence2 s, String desc) {
        return new StartDiagramExtractReader(StartDiagramExtractReader.getReadLine(is, s, desc), null);
    }

    private StartDiagramExtractReader(ReadLine raw, String suf) {
        int bloc = 0;
        String uid = null;
        if (suf != null && suf.matches("\\d+")) {
            bloc = Integer.parseInt(suf);
        } else {
            uid = suf;
        }
        if (bloc < 0) {
            bloc = 0;
        }
        this.raw = raw;
        CharSequence2 s = null;
        try {
            while ((s = raw.readLine()) != null) {
                if (!StartUtils.isArobaseStartDiagram(s) || !this.checkUid(uid, s)) continue;
                if (bloc == 0) {
                    return;
                }
                --bloc;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.error("Error " + e);
        }
        this.finished = true;
    }

    private boolean checkUid(String uid, CharSequence2 s) {
        if (uid == null) {
            return true;
        }
        return s.toString().matches(".*id=" + uid + "\\W.*");
    }

    private static ReadLine getReadLine(FileWithSuffix f2, CharSequence2 s, String charset) {
        try {
            Reader tmp1 = f2.getReader(charset);
            if (tmp1 == null) {
                return new ReadLineSimple(s, "Cannot open " + f2.getDescription());
            }
            return new UncommentReadLine(ReadLineReader.create(tmp1, f2.getDescription()));
        }
        catch (IOException e) {
            return new ReadLineSimple(s, e.toString());
        }
    }

    private static ReadLine getReadLine(InputStream is, CharSequence2 s, String description) {
        return new UncommentReadLine(ReadLineReader.create(new InputStreamReader(is), description));
    }

    private static ReadLine getReadLine(URL url, CharSequence2 s, String charset) {
        try {
            if (charset == null) {
                Log.info("Using default charset");
                return new UncommentReadLine(ReadLineReader.create(new InputStreamReader(url.openStream()), url.toString()));
            }
            Log.info("Using charset " + charset);
            return new UncommentReadLine(ReadLineReader.create(new InputStreamReader(url.openStream(), charset), url.toString()));
        }
        catch (IOException e) {
            return new ReadLineSimple(s, e.toString());
        }
    }

    public static boolean containsStartDiagram(FileWithSuffix f2, CharSequence2 s, String charset) throws IOException {
        ReadLine r = StartDiagramExtractReader.getReadLine(f2, s, charset);
        return StartDiagramExtractReader.containsStartDiagram(r);
    }

    public static boolean containsStartDiagram(URL url, CharSequence2 s, String charset) throws IOException {
        ReadLine r = StartDiagramExtractReader.getReadLine(url, s, charset);
        return StartDiagramExtractReader.containsStartDiagram(r);
    }

    public static boolean containsStartDiagram(InputStream is, CharSequence2 s, String description) throws IOException {
        ReadLine r = StartDiagramExtractReader.getReadLine(is, s, description);
        return StartDiagramExtractReader.containsStartDiagram(r);
    }

    private static boolean containsStartDiagram(ReadLine r) throws IOException {
        try {
            CharSequence2 s = null;
            while ((s = r.readLine()) != null) {
                if (!StartUtils.isArobaseStartDiagram(s)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
        return false;
    }

    @Override
    public CharSequence2 readLine() throws IOException {
        if (this.finished) {
            return null;
        }
        CharSequence2 result = this.raw.readLine();
        if (result != null && StartUtils.isArobaseEndDiagram(result)) {
            this.finished = true;
            return null;
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.raw.close();
    }
}

