/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.InGroupableList;
import net.sourceforge.plantuml.sequencediagram.graphic.GroupingGraphicalElement;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class GroupingGraphicalElementHeader
extends GroupingGraphicalElement {
    private final Component comp;
    private double endY;
    private final boolean isParallel;
    private final List<Component> notes = new ArrayList<Component>();

    public GroupingGraphicalElementHeader(double currentY, Component comp, InGroupableList inGroupableList, boolean isParallel) {
        super(currentY, inGroupableList);
        this.comp = comp;
        this.isParallel = isParallel;
    }

    public String toString() {
        return super.toString() + " " + (this.getInGroupableList() == null ? "no" : this.getInGroupableList().toString());
    }

    @Override
    public final double getPreferredWidth(StringBounder stringBounder) {
        double width = this.comp.getPreferredWidth(stringBounder);
        for (Component note : this.notes) {
            Dimension2D dimNote = note.getPreferredDimension(stringBounder);
            width += dimNote.getWidth();
        }
        return width + 5.0;
    }

    @Override
    public final double getPreferredHeight(StringBounder stringBounder) {
        return this.comp.getPreferredHeight(stringBounder);
    }

    @Override
    protected void drawInternalU(UGraphic ug, double maxX, Context2D context) {
        if (this.isParallel) {
            return;
        }
        StringBounder stringBounder = ug.getStringBounder();
        double x1 = this.getInGroupableList().getMinX(stringBounder);
        double x2 = this.getInGroupableList().getMaxX(stringBounder) - this.getInGroupableList().getHack2();
        ug = ug.apply(new UTranslate(x1, this.getStartingY()));
        double height = this.comp.getPreferredHeight(stringBounder);
        if (!(this.endY > 0.0)) {
            return;
        }
        height = this.endY - this.getStartingY();
        Dimension2DDouble dim = new Dimension2DDouble(x2 - x1, height);
        this.comp.drawU(ug, new Area(dim), context);
        for (Component note : this.notes) {
            Dimension2D dimNote = note.getPreferredDimension(stringBounder);
            note.drawU(ug.apply(new UTranslate(x2 - x1, 0.0)), new Area(dimNote), context);
        }
    }

    public void setEndY(double y) {
        this.endY = y;
    }

    public void addNotes(StringBounder stringBounder, Collection<Component> notes) {
        for (Component note : notes) {
            this.notes.add(note);
            this.getInGroupableList().changeHack2(note.getPreferredWidth(stringBounder));
        }
    }
}

