/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.tikz;

import java.awt.Color;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.tikz.TikzGraphics;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UShape;

public class DriverPolygonTikz
implements UDriver<TikzGraphics> {
    @Override
    public void draw(UShape shape, double x, double y, ColorMapper mapper, UParam param, TikzGraphics tikz) {
        UPolygon poly = (UPolygon)shape;
        double[] points = poly.getPointArray(x, y);
        HtmlColor back = param.getBackcolor();
        if (back instanceof HtmlColorGradient) {
            HtmlColorGradient gr = (HtmlColorGradient)back;
            Color color1 = mapper.getMappedColor(gr.getColor1());
            Color color2 = mapper.getMappedColor(gr.getColor2());
            tikz.setGradientColor(color1, color2, gr.getPolicy());
        } else {
            tikz.setFillColor(mapper.getMappedColor(back));
        }
        tikz.setStrokeColor(mapper.getMappedColor(param.getColor()));
        tikz.setStrokeWidth(param.getStroke().getThickness(), param.getStroke().getDashTikz());
        tikz.polygon(points);
    }
}

