/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.version;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Collection;
import java.util.Date;
import java.util.TreeSet;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.SignatureUtils;
import net.sourceforge.plantuml.dedication.Dedication;
import net.sourceforge.plantuml.dedication.QBlock;
import net.sourceforge.plantuml.version.LicenseType;
import net.sourceforge.plantuml.version.Magic;
import net.sourceforge.plantuml.version.PSystemVersion;

public class LicenseInfo {
    private static final Preferences prefs = Preferences.userNodeForPackage(LicenseInfo.class);
    private static final LicenseInfo NONE = new LicenseInfo(LicenseType.NONE, 0L, 0L, null, null);
    public static final int POS_TYPE = 2;
    public static final int POS_CONTEXT = 4;
    public static final int POS_SIGNATURE = 10;
    public static final int POS_GENERATION = 100;
    public static final int POS_EXPIRATION = 108;
    public static final int POS_OWNER = 128;
    private final LicenseType type;
    private final long generationDate;
    private final long expirationDate;
    private final String owner;
    private final String context;
    private static LicenseInfo cache;

    private LicenseInfo(LicenseType type, long generationDate, long expirationDate, String owner, String context) {
        this.type = type;
        this.generationDate = generationDate;
        this.expirationDate = expirationDate;
        this.owner = owner;
        this.context = context;
    }

    private static LicenseInfo buildNamed(Magic magic, boolean doCheck) throws NoSuchAlgorithmException, IOException {
        String local;
        String signature = SignatureUtils.toHexString(magic.get(10, 64));
        if (doCheck && !(local = SignatureUtils.toHexString(Magic.signature())).equals(signature)) {
            throw new IOException();
        }
        LicenseType type = LicenseType.fromInt(magic.getByte(Magic.signature(), 2));
        long generation = LicenseInfo.bytesToLong(magic.get(100, 8));
        long expiration = LicenseInfo.bytesToLong(magic.get(108, 8));
        String owner = magic.getString(128);
        return new LicenseInfo(type, generation, expiration, owner, null);
    }

    private static LicenseInfo buildDistributor(Magic magic) throws IOException, NoSuchAlgorithmException {
        LicenseType type = LicenseType.fromInt(magic.getByte(2));
        long generation = LicenseInfo.bytesToLong(magic.get(100, 8));
        long expiration = LicenseInfo.bytesToLong(magic.get(108, 8));
        String owner = magic.getString(128);
        String context = magic.getString(4);
        return new LicenseInfo(type, generation, expiration, owner, context);
    }

    public static long bytesToLong(byte[] b) {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result <<= 8;
            result |= (long)(b[i] & 0xFF);
        }
        return result;
    }

    public static void persistMe(String key) throws BackingStoreException {
        prefs.sync();
        prefs.put("license", key);
    }

    public static synchronized LicenseInfo retrieveQuick() {
        if (cache == null) {
            cache = LicenseInfo.retrieveDistributor();
        }
        if (cache == null) {
            cache = LicenseInfo.retrieveNamedSlow();
        }
        return cache;
    }

    public static boolean retrieveNamedOrDistributorQuickIsValid() {
        return LicenseInfo.retrieveQuick().isValid();
    }

    public static synchronized LicenseInfo retrieveNamedSlow() {
        cache = NONE;
        if (!OptionFlags.ALLOW_INCLUDE) {
            return cache;
        }
        String key = prefs.get("license", "");
        if (key.length() > 0 && (cache = LicenseInfo.setIfValid(LicenseInfo.retrieveNamed(key), cache)).isValid()) {
            return cache;
        }
        for (File f : LicenseInfo.fileCandidates()) {
            try {
                LicenseInfo result;
                if (!f.exists() || !f.canRead() || !(cache = LicenseInfo.setIfValid(result = LicenseInfo.retrieve(f), cache)).isValid()) continue;
                return cache;
            }
            catch (IOException e) {
                Log.info("Error " + e);
            }
        }
        return cache;
    }

    public static LicenseInfo retrieveNamed(String key) {
        if (key.length() > 99 && key.matches("^[0-9a-z]+$")) {
            try {
                String sig = SignatureUtils.toHexString(Magic.signature());
                return LicenseInfo.retrieveNamed(sig, key, true);
            }
            catch (Exception e) {
                Log.info("Error retrieving license info" + e);
            }
        }
        return NONE;
    }

    public static LicenseInfo retrieveNamed(String sig, String key, boolean doCheck) throws NoSuchAlgorithmException, UnsupportedEncodingException, InvalidKeySpecException, IOException {
        BigInteger lu = new BigInteger(key, 36);
        QBlock qb2 = new QBlock(lu);
        QBlock qb3 = qb2.change(Dedication.E, Dedication.N);
        Magic magic = qb3.toMagic();
        magic.xor(SignatureUtils.getSHA512raw(SignatureUtils.salting(sig, Magic.getSalt(sig))));
        return LicenseInfo.buildNamed(magic, doCheck);
    }

    public static LicenseInfo retrieveDistributor() {
        InputStream dis = PSystemVersion.class.getResourceAsStream("/distributor.txt");
        if (dis == null) {
            return null;
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(dis));
            String licenseString = br.readLine();
            br.close();
            BigInteger lu = new BigInteger(licenseString, 36);
            QBlock qb2 = new QBlock(lu);
            QBlock qb3 = qb2.change(Dedication.E, Dedication.N);
            Magic magic = qb3.toMagic();
            LicenseInfo result = LicenseInfo.buildDistributor(magic);
            Throwable creationPoint = new Throwable();
            creationPoint.fillInStackTrace();
            for (StackTraceElement ste : creationPoint.getStackTrace()) {
                if (!ste.toString().contains(result.context)) continue;
                return result;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Collection<File> fileCandidates() {
        String[] classpathEntries;
        TreeSet<File> result = new TreeSet<File>();
        String classpath = System.getProperty("java.class.path");
        for (String s : classpathEntries = classpath.split(File.pathSeparator)) {
            File dir = new File(s);
            if (dir.isFile()) {
                dir = dir.getParentFile();
            }
            if (dir == null || !dir.isDirectory()) continue;
            result.add(new File(dir, "license.txt"));
        }
        return result;
    }

    private static LicenseInfo setIfValid(LicenseInfo value, LicenseInfo def) {
        if (value.isValid() || def.isNone()) {
            return value;
        }
        return def;
    }

    private static LicenseInfo retrieve(File f) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(f));
        String s = br.readLine();
        br.close();
        LicenseInfo result = LicenseInfo.retrieveNamed(s);
        if (result != null) {
            Log.info("Reading license from " + f.getAbsolutePath());
        }
        return result;
    }

    public static void main(String[] args) {
        LicenseInfo info = LicenseInfo.retrieveNamedSlow();
        System.err.println("valid=" + info.isValid());
        System.err.println("info=" + info.owner);
    }

    public final Date getGenerationDate() {
        return new Date(this.generationDate);
    }

    public final Date getExpirationDate() {
        return new Date(this.expirationDate);
    }

    public final String getOwner() {
        return this.owner;
    }

    public boolean isNone() {
        return this.owner == null;
    }

    public boolean isValid() {
        return this.owner != null && System.currentTimeMillis() <= this.expirationDate;
    }

    public boolean hasExpired() {
        return this.owner != null && System.currentTimeMillis() > this.expirationDate;
    }

    public final LicenseType getLicenseType() {
        return this.type;
    }

    public final String getContext() {
        return this.context;
    }
}

