/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole.command;

import java.util.EnumSet;
import net.sourceforge.plantuml.klimt.creole.command.AddStyle;
import net.sourceforge.plantuml.klimt.creole.command.ColorAndSizeChange;
import net.sourceforge.plantuml.klimt.creole.command.ColorChange;
import net.sourceforge.plantuml.klimt.creole.command.ExposantChange;
import net.sourceforge.plantuml.klimt.creole.command.FontFamilyChange;
import net.sourceforge.plantuml.klimt.creole.command.HtmlCommand;
import net.sourceforge.plantuml.klimt.creole.command.Img;
import net.sourceforge.plantuml.klimt.creole.command.PlainText;
import net.sourceforge.plantuml.klimt.creole.command.RemoveStyle;
import net.sourceforge.plantuml.klimt.creole.command.ResetFont;
import net.sourceforge.plantuml.klimt.creole.command.SizeChange;
import net.sourceforge.plantuml.klimt.creole.command.Splitter;
import net.sourceforge.plantuml.klimt.creole.command.SpriteCommand;
import net.sourceforge.plantuml.klimt.creole.command.SvgAttributesChange;
import net.sourceforge.plantuml.klimt.creole.command.TextLink;
import net.sourceforge.plantuml.klimt.font.FontPosition;
import net.sourceforge.plantuml.klimt.font.FontStyle;
import net.sourceforge.plantuml.regex.MyPattern;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.url.UrlBuilder;
import net.sourceforge.plantuml.url.UrlMode;

class HtmlCommandFactory {
    static final Pattern2 addStyle;
    static final Pattern2 removeStyle;
    private Pattern2 htmlTag = MyPattern.cmpile(Splitter.htmlTag);

    HtmlCommandFactory() {
    }

    HtmlCommand getHtmlCommand(String s) {
        if (!this.htmlTag.matcher(s).matches()) {
            return new PlainText(s);
        }
        if (MyPattern.mtches(s, "\\<img\\s+(src[%s]*=[%s]*[%q%g]?[^\\s%g>]+[%q%g]?[%s]*|vspace\\s*=\\s*[%q%g]?\\d+[%q%g]?\\s*|valign[%s]*=[%s]*[%q%g]?(top|middle|bottom)[%q%g]?[%s]*)+\\>")) {
            return Img.getInstance(s, true);
        }
        if (MyPattern.mtches(s, "\\<img[\\s:]+([^>{}]+)(\\{scale=(?:[0-9.]+)\\})?\\>")) {
            return Img.getInstance(s, false);
        }
        if (addStyle.matcher(s).matches()) {
            return AddStyle.fromString(s);
        }
        if (removeStyle.matcher(s).matches()) {
            return new RemoveStyle(FontStyle.getStyle(s));
        }
        if (MyPattern.mtches(s, "\\<font(\\s+size[%s]*=[%s]*[%g]?\\d+[%g]?|[%s]+color[%s]*=\\s*[%g]?(#[0-9a-fA-F]{6}|\\w+)[%g]?)+[%s]*\\>")) {
            return new ColorAndSizeChange(s);
        }
        if (MyPattern.mtches(s, "\\<color[\\s:]+(#[0-9a-fA-F]{6}|#?\\w+)[%s]*\\>")) {
            return new ColorChange(s);
        }
        if (MyPattern.mtches(s, "\\<size[\\s:]+(\\d+)[%s]*\\>")) {
            return new SizeChange(s);
        }
        if (MyPattern.mtches(s, "\\<sup\\>")) {
            return new ExposantChange(FontPosition.EXPOSANT);
        }
        if (MyPattern.mtches(s, "\\<sub\\>")) {
            return new ExposantChange(FontPosition.INDICE);
        }
        if (MyPattern.mtches(s, "\\</font\\>|\\</color\\>|\\</size\\>|\\</text\\>")) {
            return new ResetFont();
        }
        if (MyPattern.mtches(s, "\\</sup\\>|\\</sub\\>")) {
            return new ExposantChange(FontPosition.NORMAL);
        }
        if (MyPattern.mtches(s, "\\<font[\\s:]+([^>]+)/?\\>")) {
            return new FontFamilyChange(s);
        }
        if (MyPattern.mtches(s, "\\<\\$([-\\p{L}0-9_/]+)([\\{,]?(?:(?:scale=|\\*)[0-9.]+)?(?:,color[= :](?:#[0-9a-fA-F]{6}|\\w+))?\\}?)?\\>")) {
            return new SpriteCommand(s);
        }
        if (MyPattern.mtches(s, "\\[\\[([^\\[\\]]+)\\]\\]")) {
            UrlBuilder urlBuilder = new UrlBuilder(null, UrlMode.STRICT);
            Url url = urlBuilder.getUrl(s);
            url.setMember(true);
            return new TextLink(url);
        }
        if (MyPattern.mtches(s, "\\<text[\\s:]+([^>]+)/?\\>")) {
            return new SvgAttributesChange(s);
        }
        return null;
    }

    static {
        StringBuilder sbAddStyle = new StringBuilder();
        StringBuilder sbRemoveStyle = new StringBuilder();
        for (FontStyle style : EnumSet.allOf(FontStyle.class)) {
            if (sbAddStyle.length() > 0) {
                sbAddStyle.append('|');
                sbRemoveStyle.append('|');
            }
            sbAddStyle.append(style.getActivationPattern());
            sbRemoveStyle.append(style.getDeactivationPattern());
        }
        addStyle = MyPattern.cmpile(sbAddStyle.toString());
        removeStyle = MyPattern.cmpile(sbRemoveStyle.toString());
    }
}

