/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.util.Set;
import net.sourceforge.plantuml.AlignmentParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FloatingNote;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UGraphicInterceptorUDrawable;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.svek.UGraphicForSnake;
import net.sourceforge.plantuml.ugraphic.LimitFinder;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.utils.MathUtils;

public class FtileGroup
extends AbstractFtile {
    private final double diffYY2 = 20.0;
    private final Ftile inner;
    private final TextBlock name;
    private final TextBlock headerNote;
    private final HtmlColor borderColor;
    private final HtmlColor backColor;
    private final UStroke stroke;
    private final USymbol type;
    private final double roundCorner;
    private FtileGeometry cachedInnerDimension;

    public FtileGroup(Ftile inner, Display title, Display displayNote, HtmlColor arrowColor, HtmlColor backColor, HtmlColor titleColor, ISkinParam skinParam, HtmlColor borderColor, USymbol type, double roundCorner) {
        super(inner.skinParam());
        this.roundCorner = roundCorner;
        this.type = type;
        this.backColor = backColor == null ? HtmlColorUtils.WHITE : backColor;
        this.inner = FtileUtils.addHorizontalMargin(inner, 10.0);
        this.borderColor = borderColor == null ? HtmlColorUtils.BLACK : borderColor;
        UFont font = skinParam.getFont(null, false, FontParam.PARTITION);
        HtmlColor fontColor = skinParam.getFontHtmlColor(null, FontParam.PARTITION);
        FontConfiguration fc = new FontConfiguration(font, fontColor, skinParam.getHyperlinkColor(), skinParam.useUnderlineForHyperlink(), skinParam.getTabSize());
        this.name = title == null ? TextBlockUtils.empty(0.0, 0.0) : title.create(fc, HorizontalAlignment.LEFT, skinParam);
        this.headerNote = Display.isNull(displayNote) ? TextBlockUtils.empty(0.0, 0.0) : new FloatingNote(displayNote, skinParam);
        UStroke thickness = skinParam.getThickness(LineParam.partitionBorder, null);
        this.stroke = thickness == null ? new UStroke(2.0) : thickness;
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.inner.getInLinkRendering();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.inner.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.inner.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.inner.getSwimlaneOut();
    }

    private double diffHeightTitle(StringBounder stringBounder) {
        Dimension2D dimTitle = this.name.calculateDimension(stringBounder);
        return Math.max(25.0, dimTitle.getHeight() + 20.0);
    }

    private UTranslate getTranslate(StringBounder stringBounder) {
        double suppWidth = this.suppWidth(stringBounder);
        return new UTranslate(suppWidth / 2.0, this.diffHeightTitle(stringBounder) + this.headerNoteHeight(stringBounder));
    }

    private MinMax getInnerMinMax(StringBounder stringBounder) {
        LimitFinder limitFinder = new LimitFinder(stringBounder, false);
        UGraphicForSnake interceptor = new UGraphicForSnake(limitFinder);
        UGraphicInterceptorUDrawable interceptor2 = new UGraphicInterceptorUDrawable(interceptor);
        this.inner.drawU(interceptor2);
        interceptor2.flushUg();
        return limitFinder.getMinMax();
    }

    public double suppWidth(StringBounder stringBounder) {
        FtileGeometry orig = this.getInnerDimension(stringBounder);
        Dimension2D dimTitle = this.name.calculateDimension(stringBounder);
        Dimension2D dimHeaderNote = this.headerNote.calculateDimension(stringBounder);
        double suppWidth = MathUtils.max(orig.getWidth(), dimTitle.getWidth() + 20.0, dimHeaderNote.getWidth() + 20.0) - orig.getWidth();
        return suppWidth;
    }

    private FtileGeometry getInnerDimension(StringBounder stringBounder) {
        if (this.cachedInnerDimension == null) {
            this.cachedInnerDimension = this.getInnerDimensionSlow(stringBounder);
        }
        return this.cachedInnerDimension;
    }

    private FtileGeometry getInnerDimensionSlow(StringBounder stringBounder) {
        FtileGeometry orig = this.inner.calculateDimension(stringBounder);
        MinMax minMax = this.getInnerMinMax(stringBounder);
        double missingWidth = minMax.getMaxX() - orig.getWidth();
        if (missingWidth > 0.0) {
            return orig.addDim(missingWidth + 5.0, 0.0);
        }
        return orig;
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        FtileGeometry orig = this.getInnerDimension(stringBounder);
        double suppWidth = this.suppWidth(stringBounder);
        double width = orig.getWidth() + suppWidth;
        double height = orig.getHeight() + this.diffHeightTitle(stringBounder) + 20.0 + this.headerNoteHeight(stringBounder);
        double titleAndHeaderNoteHeight = this.diffHeightTitle(stringBounder) + this.headerNoteHeight(stringBounder);
        if (orig.hasPointOut()) {
            return new FtileGeometry(width, height, orig.getLeft() + suppWidth / 2.0, orig.getInY() + titleAndHeaderNoteHeight, orig.getOutY() + titleAndHeaderNoteHeight);
        }
        return new FtileGeometry(width, height, orig.getLeft() + suppWidth / 2.0, orig.getInY() + titleAndHeaderNoteHeight);
    }

    private double headerNoteHeight(StringBounder stringBounder) {
        return this.headerNote.calculateDimension(stringBounder).getHeight();
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        FtileGeometry dimTotal = this.calculateDimension(stringBounder);
        SymbolContext symbolContext = new SymbolContext(this.backColor, this.borderColor).withShadow(this.skinParam().shadowing(null)).withStroke(this.stroke).withCorner(this.roundCorner, 0.0);
        this.type.asBig(this.name, this.inner.skinParam().getHorizontalAlignment(AlignmentParam.packageTitleAlignment, null, false), TextBlockUtils.empty(0.0, 0.0), ((Dimension2D)dimTotal).getWidth(), ((Dimension2D)dimTotal).getHeight(), symbolContext).drawU(ug);
        Dimension2D dimHeaderNote = this.headerNote.calculateDimension(stringBounder);
        this.headerNote.drawU(ug.apply(new UTranslate(((Dimension2D)dimTotal).getWidth() - dimHeaderNote.getWidth() - 10.0, this.diffHeightTitle(ug.getStringBounder()) - 10.0)));
        ug.apply(this.getTranslate(stringBounder)).draw(this.inner);
    }
}

