/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.MyPattern;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.style.AutomaticCounter;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleLoader;
import net.sourceforge.plantuml.style.StyleScheme;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.style.Value;
import net.sourceforge.plantuml.style.ValueImpl;
import net.sourceforge.plantuml.style.parser.Context;
import net.sourceforge.plantuml.style.parser.CssVariables;
import net.sourceforge.plantuml.style.parser.StyleParser;
import net.sourceforge.plantuml.style.parser.StyleParsingException;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.utils.BlocLines;

public class StyleParserLegacy {
    private static final String KEYNAMES = "[-.\\w(), ]+?";
    private static final Pattern2 keyName = MyPattern.cmpile("^[:]?([-.\\w(), ]+?)([%s]+\\*)?[%s]*\\{$");
    private static final Pattern2 propertyAndValue = MyPattern.cmpile("^([\\w]+):?[%s]+(.*?);?$");
    private static final Pattern2 closeBracket = MyPattern.cmpile("^\\}$");

    public static Collection<Style> parse(BlocLines lines, AutomaticCounter counter) throws StyleParsingException {
        Collection<Style> foo = StyleParser.parse(lines, counter);
        lines = lines.eventuallyMoveAllEmptyBracket();
        ArrayList<Style> result = new ArrayList<Style>();
        CssVariables variables = new CssVariables();
        StyleScheme scheme = StyleScheme.REGULAR;
        Context context = new Context();
        ArrayList maps = new ArrayList();
        boolean inComment = false;
        for (StringLocated s : lines) {
            Matcher2 mKeyNames;
            String trimmed = s.getTrimmed().getString();
            if (trimmed.startsWith("/*") || trimmed.endsWith("*/") || trimmed.startsWith("/'") || trimmed.endsWith("'/")) continue;
            if (trimmed.startsWith("/*") || trimmed.startsWith("/'")) {
                inComment = true;
                continue;
            }
            if (trimmed.endsWith("*/") || trimmed.endsWith("'/")) {
                inComment = false;
                continue;
            }
            if (inComment) continue;
            if (trimmed.matches("@media.*dark.*\\{")) {
                scheme = StyleScheme.DARK;
                continue;
            }
            if (trimmed.startsWith("--")) {
                variables.learn(trimmed);
                continue;
            }
            int x = trimmed.lastIndexOf("//");
            if (x != -1) {
                trimmed = trimmed.substring(0, x).trim();
            }
            if ((mKeyNames = keyName.matcher(trimmed)).find()) {
                boolean isRecurse;
                String names = mKeyNames.group(1);
                boolean bl = isRecurse = mKeyNames.group(2) != null;
                if (isRecurse) {
                    names = names + "*";
                }
                context = context.push(names);
                maps.add(new EnumMap(PName.class));
                continue;
            }
            Matcher2 mPropertyAndValue = propertyAndValue.matcher(trimmed);
            if (mPropertyAndValue.find()) {
                PName key = PName.getFromName(mPropertyAndValue.group(1), scheme);
                String value = variables.value(mPropertyAndValue.group(2));
                if (key == null || maps.size() <= 0) continue;
                ((Map)maps.get(maps.size() - 1)).put(key, scheme == StyleScheme.REGULAR ? ValueImpl.regular(value, counter) : ValueImpl.dark(value, counter));
                continue;
            }
            Matcher2 mCloseBracket = closeBracket.matcher(trimmed);
            if (!mCloseBracket.find()) continue;
            if (context.size() > 0) {
                Collection<StyleSignatureBasic> signatures = context.toSignatures();
                for (StyleSignatureBasic signature : signatures) {
                    Map<PName, Value> tmp = (Map<PName, Value>)maps.get(maps.size() - 1);
                    if (signature.isWithDot()) {
                        tmp = StyleLoader.addPriorityForStereotype(tmp);
                    }
                    if (tmp.size() <= 0) continue;
                    Style style = new Style(signature, tmp);
                    result.add(style);
                }
                context = context.pop();
                maps.remove(maps.size() - 1);
                continue;
            }
            scheme = StyleScheme.REGULAR;
        }
        System.err.println("foo1=" + foo.size());
        System.err.println("result=" + result.size());
        if (foo.size() != result.size() || foo.size() < 10) {
            StyleParserLegacy.print_debug(foo);
            StyleParserLegacy.print_debug(result);
        }
        return Collections.unmodifiableCollection(foo);
    }

    private static void print_debug(Collection<Style> list) {
        System.err.println("=====================");
        int i = 0;
        for (Style style : list) {
            System.err.println("style=" + i + " " + style.getSignature());
            ++i;
        }
        System.err.println("=====================");
    }
}

