/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.mif;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.flow.BasicLink;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.fo.flow.Character;
import org.apache.fop.fo.flow.ExternalGraphic;
import org.apache.fop.fo.flow.Footnote;
import org.apache.fop.fo.flow.FootnoteBody;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.fo.flow.InstreamForeignObject;
import org.apache.fop.fo.flow.Leader;
import org.apache.fop.fo.flow.ListBlock;
import org.apache.fop.fo.flow.ListItem;
import org.apache.fop.fo.flow.ListItemBody;
import org.apache.fop.fo.flow.ListItemLabel;
import org.apache.fop.fo.flow.PageNumber;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableBody;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.flow.table.TableFooter;
import org.apache.fop.fo.flow.table.TableHeader;
import org.apache.fop.fo.flow.table.TableRow;
import org.apache.fop.fo.pagination.Flow;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.fo.pagination.StaticContent;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontSetup;
import org.apache.fop.render.mif.MIFElement;
import org.apache.fop.render.mif.MIFFile;
import org.xml.sax.SAXException;

public class MIFHandler
extends FOEventHandler {
    private static Log log = LogFactory.getLog(MIFHandler.class);
    protected MIFFile mifFile;
    protected OutputStream outStream;
    private MIFElement textFlow;
    private MIFElement para;

    public MIFHandler(FOUserAgent ua, OutputStream os) {
        super(ua);
        this.outStream = os;
        boolean base14Kerning = false;
        FontSetup.setup((FontInfo)this.fontInfo, null, (InternalResourceResolver)ua.getResourceResolver(), (boolean)base14Kerning);
    }

    public void startDocument() throws SAXException {
        log.fatal((Object)"The MIF Handler is non-functional at this time. Please help resurrect it!");
        this.mifFile = new MIFFile();
        try {
            this.mifFile.output(this.outStream);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void endDocument() throws SAXException {
        this.mifFile.finish(true);
        try {
            this.mifFile.output(this.outStream);
            this.outStream.flush();
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void startPageSequence(PageSequence pageSeq) {
        String name = pageSeq.getMasterReference();
        SimplePageMaster spm = pageSeq.getRoot().getLayoutMasterSet().getSimplePageMaster(name);
        if (spm != null) {
            MIFElement prop = new MIFElement("PageType");
            prop.setValue("BodyPage");
            MIFElement page = new MIFElement("Page");
            page.addElement(prop);
            prop = new MIFElement("PageBackground");
            prop.setValue("'Default'");
            page.addElement(prop);
            MIFElement textRect = new MIFElement("TextRect");
            prop = new MIFElement("ID");
            prop.setValue("1");
            textRect.addElement(prop);
            prop = new MIFElement("ShapeRect");
            prop.setValue("0.0 841.889 453.543 0.0");
            textRect.addElement(prop);
            page.addElement(textRect);
            textRect = new MIFElement("TextRect");
            prop = new MIFElement("ID");
            prop.setValue("2");
            textRect.addElement(prop);
            prop = new MIFElement("ShapeRect");
            prop.setValue("0.0 841.889 453.543 187.65");
            textRect.addElement(prop);
            page.addElement(textRect);
            this.mifFile.addPage(page);
        }
    }

    public void endPageSequence(PageSequence pageSeq) {
    }

    public void startFlow(Flow fl) {
        this.textFlow = new MIFElement("TextFlow");
    }

    public void endFlow(Flow fl) {
        this.textFlow.finish(true);
        this.mifFile.addElement(this.textFlow);
        this.textFlow = null;
    }

    public void startBlock(Block bl) {
        this.para = new MIFElement("Para");
        this.textFlow.addElement(this.para);
    }

    public void endBlock(Block bl) {
        this.para.finish(true);
        this.para = null;
    }

    public void startInline(Inline inl) {
    }

    public void endInline(Inline inl) {
    }

    public void startTable(Table tbl) {
    }

    public void endTable(Table tbl) {
    }

    public void startColumn(TableColumn tc) {
    }

    public void endColumn(TableColumn tc) {
    }

    public void startHeader(TableHeader th) {
    }

    public void endHeader(TableHeader th) {
    }

    public void startFooter(TableFooter tf) {
    }

    public void endFooter(TableFooter tf) {
    }

    public void startBody(TableBody tb) {
    }

    public void endBody(TableBody tb) {
    }

    public void startRow(TableRow tr) {
    }

    public void endRow(TableRow tr) {
    }

    public void startCell(TableCell tc) {
    }

    public void endCell(TableCell tc) {
    }

    public void startList(ListBlock lb) {
    }

    public void endList(ListBlock lb) {
    }

    public void startListItem(ListItem li) {
    }

    public void endListItem(ListItem li) {
    }

    public void startListLabel(ListItemLabel listItemLabel) {
    }

    public void endListLabel(ListItemLabel listItemLabel) {
    }

    public void startListBody(ListItemBody listItemBody) {
    }

    public void endListBody(ListItemBody listItemBody) {
    }

    public void startStatic(StaticContent staticContent) {
    }

    public void endStatic(StaticContent staticContent) {
    }

    public void startMarkup() {
    }

    public void endMarkup() {
    }

    public void startLink(BasicLink basicLink) {
    }

    public void endLink(BasicLink basicLink) {
    }

    public void image(ExternalGraphic eg) {
    }

    public void pageRef() {
    }

    public void startInstreamForeignObject(InstreamForeignObject ifo) {
    }

    public void endInstreamForeignObject(InstreamForeignObject ifo) {
    }

    public void startFootnote(Footnote footnote) {
    }

    public void endFootnote(Footnote footnote) {
    }

    public void startFootnoteBody(FootnoteBody body) {
    }

    public void endFootnoteBody(FootnoteBody body) {
    }

    public void startLeader(Leader l) {
    }

    public void endLeader(Leader l) {
    }

    public void character(Character c) {
        this.appendCharacters(new String(new char[]{c.getCharacter()}));
    }

    public void characters(FOText foText) {
        this.appendCharacters(foText.getCharSequence().toString());
    }

    public void startPageNumber(PageNumber pagenum) {
    }

    public void endPageNumber(PageNumber pagenum) {
    }

    private void appendCharacters(String str) {
        if (this.para != null) {
            if ((str = str.trim()).length() == 0) {
                return;
            }
            MIFElement line = new MIFElement("ParaLine");
            MIFElement prop = new MIFElement("TextRectID");
            prop.setValue("2");
            line.addElement(prop);
            prop = new MIFElement("String");
            prop.setValue("\"" + str + "\"");
            line.addElement(prop);
            this.para.addElement(line);
        }
    }
}

