/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.util.List;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.IEntity;

public class CommandUrl
extends SingleLineCommand<AbstractEntityDiagram> {
    public CommandUrl() {
        super("(?i)^url[%s]*(?:of|for)?[%s]+([\\p{L}0-9_.]+|[%g][^%g]+[%g])[%s]+(?:is)?[%s]*(" + UrlBuilder.getRegexp() + ")$");
    }

    @Override
    protected CommandExecutionResult executeArg(AbstractEntityDiagram diagram, List<String> arg) {
        IEntity entity;
        Code code = Code.of(arg.get(0));
        String urlString = arg.get(1);
        if (diagram.leafExist(code)) {
            entity = diagram.getOrCreateLeaf(code, null, null);
        } else if (diagram.isGroup(code)) {
            entity = diagram.getGroup(code);
        } else {
            return CommandExecutionResult.error(code + " does not exist");
        }
        UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
        Url url = urlBuilder.getUrl(urlString);
        entity.addUrl(url);
        return CommandExecutionResult.ok();
    }
}

