/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.code;

import java.io.IOException;
import net.sourceforge.plantuml.code.Compression;
import net.sourceforge.plantuml.code.StringCompressor;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.URLEncoder;

public class TranscoderImpl
implements Transcoder {
    private final Compression compression;
    private final URLEncoder urlEncoder;
    private final StringCompressor stringCompressor;

    public TranscoderImpl(URLEncoder urlEncoder, StringCompressor stringCompressor, Compression compression) {
        this.compression = compression;
        this.urlEncoder = urlEncoder;
        this.stringCompressor = stringCompressor;
    }

    @Override
    public String encode(String text) throws IOException {
        String stringAnnoted = this.stringCompressor.compress(text);
        byte[] data = stringAnnoted.getBytes("UTF-8");
        byte[] compressedData = this.compression.compress(data);
        return this.urlEncoder.encode(compressedData);
    }

    @Override
    public String decode(String code) throws IOException {
        byte[] compressedData = this.urlEncoder.decode(code);
        byte[] data = this.compression.decompress(compressedData);
        return this.stringCompressor.decompress(new String(data, "UTF-8"));
    }
}

