/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt;

import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.klimt.UChange;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;

public class UClip
implements UChange {
    private final double x;
    private final double y;
    private final double width;
    private final double height;

    public UClip(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public UClip enlarge(double delta) {
        return new UClip(this.x - delta, this.y - delta, this.width + 2.0 * delta, this.height + 2.0 * delta);
    }

    public String toString() {
        return "CLIP x=" + this.x + " y=" + this.y + " w=" + this.width + " h=" + this.height;
    }

    public UClip translate(double dx, double dy) {
        return new UClip(this.x + dx, this.y + dy, this.width, this.height);
    }

    public UClip translate(UTranslate translate) {
        return this.translate(translate.getDx(), translate.getDy());
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    public boolean isInside(XPoint2D pt) {
        return this.isInside(pt.getX(), pt.getY());
    }

    public boolean isInside(double xp, double yp) {
        if (xp < this.x) {
            assert (this.getClippedX(xp) != xp);
            return false;
        }
        if (xp > this.x + this.width) {
            assert (this.getClippedX(xp) != xp);
            return false;
        }
        if (yp < this.y) {
            assert (this.getClippedY(yp) != yp);
            return false;
        }
        if (yp > this.y + this.height) {
            assert (this.getClippedY(yp) != yp);
            return false;
        }
        assert (this.getClippedX(xp) == xp);
        assert (this.getClippedY(yp) == yp);
        return true;
    }

    public Rectangle2D.Double getClippedRectangle(Rectangle2D.Double r) {
        return (Rectangle2D.Double)r.createIntersection(new Rectangle2D.Double(this.x, this.y, this.width, this.height));
    }

    public Line2D.Double getClippedLine(Line2D.Double line) {
        if (this.isInside(line.x1, line.y1) && this.isInside(line.x2, line.y2)) {
            return line;
        }
        if (!this.isInside(line.x1, line.y1) && !this.isInside(line.x2, line.y2)) {
            double newy2;
            double newy1;
            if (line.x1 == line.x2 && (newy1 = this.getClippedY(line.y1)) != (newy2 = this.getClippedY(line.y2))) {
                return new Line2D.Double(line.x1, newy1, line.x2, newy2);
            }
            return null;
        }
        if (line.x1 != line.x2 && line.y1 != line.y2) {
            return null;
        }
        assert (line.x1 == line.x2 || line.y1 == line.y2);
        if (line.y1 == line.y2) {
            double newx1 = this.getClippedX(line.x1);
            double newx2 = this.getClippedX(line.x2);
            return new Line2D.Double(newx1, line.y1, newx2, line.y2);
        }
        if (line.x1 == line.x2) {
            double newy1 = this.getClippedY(line.y1);
            double newy2 = this.getClippedY(line.y2);
            return new Line2D.Double(line.x1, newy1, line.x2, newy2);
        }
        throw new IllegalStateException();
    }

    public boolean isInside(double x, double y, UPath shape) {
        return this.isInside(x + shape.getMinX(), y + shape.getMinY()) && this.isInside(x + shape.getMaxX(), y + shape.getMaxY());
    }

    private double getClippedX(double xp) {
        if (xp < this.x) {
            return this.x;
        }
        if (xp > this.x + this.width) {
            return this.x + this.width;
        }
        return xp;
    }

    private double getClippedY(double yp) {
        if (yp < this.y) {
            return this.y;
        }
        if (yp > this.y + this.height) {
            return this.y + this.height;
        }
        return yp;
    }
}

