/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;

public class CommandMultilinesFooter
extends CommandMultilines<UmlDiagram> {
    public CommandMultilinesFooter() {
        super("(?i)^(?:(left|right|center)?[%s]*)footer$");
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^end[%s]?footer$";
    }

    @Override
    public CommandExecutionResult execute(UmlDiagram diagram, BlocLines lines) {
        lines = lines.trim(false);
        Matcher2 m = this.getStartingPattern().matcher(StringUtils.trin(lines.getFirst499()));
        if (!m.find()) {
            throw new IllegalStateException();
        }
        String align = m.group(1);
        Display strings = (lines = lines.subExtract(1, 1)).toDisplay();
        if (strings.size() > 0) {
            diagram.getFooter().put(strings, HorizontalAlignment.fromString(align, HorizontalAlignment.CENTER));
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Empty footer");
    }
}

