/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cute;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.cute.Balloon;

public class TriangleCornerSimple {
    private final Point2D a;
    private final Point2D b;

    public String toString() {
        return "TriangleCornerSimple a=" + this.a + " " + Math.toDegrees(this.getAngleA()) + " b=" + this.b + " " + Math.toDegrees(this.getAngleB());
    }

    public TriangleCornerSimple(Point2D a, Point2D b) {
        if (!TriangleCornerSimple.isZero(a.getX())) {
            throw new IllegalArgumentException("a=" + a);
        }
        this.a = a;
        this.b = b;
    }

    private static boolean isZero(double v) {
        return Math.abs(v) < 1.0E-4;
    }

    double getAngleA() {
        return this.getAngle(this.a);
    }

    double getAngleB() {
        return this.getAngle(this.b);
    }

    double getAngle(Point2D pt) {
        double dx = pt.getX();
        double dy = pt.getY();
        return Math.atan2(dy, dx);
    }

    static double solveY(double alpha, double x) {
        if (alpha < 0.0 || alpha > 1.5707963267948966) {
            throw new IllegalArgumentException();
        }
        return x * Math.tan(alpha);
    }

    static double solveX(double alpha, double y) {
        if (alpha < -1.5707963267948966 || alpha > 1.5707963267948966) {
            // empty if block
        }
        double beta = 1.5707963267948966 - alpha;
        return y * Math.tan(beta);
    }

    public Point2D getCenterWithFixedRadius(double radius) {
        double alpha = (this.getAngleA() + this.getAngleB()) / 2.0;
        double y = TriangleCornerSimple.solveY(alpha, radius);
        return new Point2D.Double(radius, y);
    }

    public Balloon getBalloonWithFixedY(double y) {
        double alpha = (this.getAngleA() + this.getAngleB()) / 2.0;
        double sign = Math.signum(this.a.getY());
        double x = TriangleCornerSimple.solveX(alpha, y);
        Balloon result = new Balloon(new Point2D.Double(x * sign, y * sign), Math.abs(x));
        return result;
    }
}

