/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc2;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.DefinitionsContainer;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.preproc.DefinesGet;
import net.sourceforge.plantuml.preproc.FileWithSuffix;
import net.sourceforge.plantuml.preproc.ImportedFiles;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineEmpty;
import net.sourceforge.plantuml.preproc.ReadLineList;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.ReadLineSimple;
import net.sourceforge.plantuml.preproc.ReadLineSingle;
import net.sourceforge.plantuml.preproc.StartDiagramExtractReader;
import net.sourceforge.plantuml.preproc.Stdlib;
import net.sourceforge.plantuml.preproc2.Preprocessor2;
import net.sourceforge.plantuml.preproc2.PreprocessorIncludeStrategy;
import net.sourceforge.plantuml.preproc2.ReadFilter;
import net.sourceforge.plantuml.preproc2.ReadLineInsertable;
import net.sourceforge.plantuml.utils.StartUtils;

public class PreprocessorInclude3
implements ReadFilter {
    private static final Pattern2 includeDefPattern = MyPattern.cmpile("^[%s]*!includedef[%s]+[%g]?([^%g]+)[%g]?$");
    private static final Pattern2 includeDefaultStrategy = MyPattern.cmpile("^[%s]*!default_include[%s]+(once|many)$");
    private static final Pattern2 includePattern = MyPattern.cmpile("^[%s]*!include[%s]+[%g]?([^%g]+)[%g]?$");
    private static final Pattern2 includeManyPattern = MyPattern.cmpile("^[%s]*!include_many[%s]+[%g]?([^%g]+)[%g]?$");
    private static final Pattern2 includeOncePattern = MyPattern.cmpile("^[%s]*!include_once[%s]+[%g]?([^%g]+)[%g]?$");
    private static final Pattern2 importPattern = MyPattern.cmpile("^[%s]*!import[%s]+[%g]?([^%g]+)[%g]?$");
    private static final Pattern2 includePatternStdlib = MyPattern.cmpile("^[%s]*!include[%s]+(\\<[^%g]+\\>)$");
    private static final Pattern2 includeURLPattern = MyPattern.cmpile("^[%s]*!includeurl[%s]+[%g]?([^%g]+)[%g]?$");
    private final String charset;
    private final DefinesGet defines;
    private final List<String> config;
    private final DefinitionsContainer definitionsContainer;
    private final ImportedFiles importedFiles;
    private final Set<FileWithSuffix> filesUsedCurrent = new HashSet<FileWithSuffix>();
    private final Set<FileWithSuffix> filesUsedGlobal;
    private PreprocessorIncludeStrategy strategy = PreprocessorIncludeStrategy.ONCE;

    public PreprocessorInclude3(List<String> config, String charset, DefinesGet defines, DefinitionsContainer definitionsContainer, ImportedFiles importedFiles, Set<FileWithSuffix> filesUsedGlobal) {
        this.charset = charset;
        this.config = config;
        this.defines = defines;
        this.definitionsContainer = definitionsContainer;
        this.importedFiles = importedFiles;
        this.filesUsedGlobal = filesUsedGlobal;
    }

    @Override
    public ReadLine applyFilter(ReadLine source) {
        return new Inner(source);
    }

    private CharSequence2 manageFileImport(CharSequence2 s, Matcher2 m) throws IOException {
        String fileName = m.group(1);
        File file = FileSystem.getInstance().getFile(PreprocessorInclude3.withEnvironmentVariable(fileName));
        if (file.exists() && !file.isDirectory()) {
            this.importedFiles.add(file);
            return null;
        }
        return s.withErrorPreprocessor("Cannot import " + FileWithSuffix.getFileName(file));
    }

    private ReadLine manageUrlInclude(CharSequence2 s, Matcher2 m) throws IOException {
        String urlString = m.group(1);
        urlString = this.defines.get().applyDefines(urlString).get(0);
        int idx = urlString.lastIndexOf(33);
        String suf = null;
        if (idx != -1) {
            suf = urlString.substring(idx + 1);
            urlString = urlString.substring(0, idx);
        }
        try {
            if (!urlString.toLowerCase().startsWith("https://") && !urlString.toLowerCase().startsWith("http://")) {
                return new ReadLineSingle(s.withErrorPreprocessor("Cannot include url " + urlString));
            }
            URL url = new URL(urlString);
            return new Preprocessor2(this.config, this.getReaderInclude(url, s, suf), this.charset, this.defines, this.definitionsContainer, this.filesUsedGlobal, this.importedFiles);
        }
        catch (MalformedURLException e) {
            return new ReadLineSingle(s.withErrorPreprocessor("Cannot include url " + urlString));
        }
    }

    private ReadLine manageDefinitionInclude(CharSequence2 s, Matcher2 matcher) throws IOException {
        String definitionName = matcher.group(1);
        List<? extends CharSequence> definition = this.definitionsContainer.getDefinition(definitionName);
        return new Preprocessor2(this.config, new ReadLineList(definition, s.getLocation()), this.charset, this.defines, this.definitionsContainer, this.filesUsedGlobal, this.importedFiles);
    }

    private ReadLine manageFileInclude(CharSequence2 s, Matcher2 matcher, PreprocessorIncludeStrategy allowMany) throws IOException {
        FileWithSuffix f2;
        String fileName = matcher.group(1);
        fileName = this.defines.get().applyDefines(fileName).get(0);
        if (fileName.startsWith("<") && fileName.endsWith(">")) {
            ReadLine strlibReader = this.getReaderStdlibInclude(s, fileName.substring(1, fileName.length() - 1));
            if (strlibReader == null) {
                return new ReadLineSingle(s.withErrorPreprocessor("Cannot include " + fileName));
            }
            return new Preprocessor2(this.config, strlibReader, this.charset, this.defines, this.definitionsContainer, this.filesUsedGlobal, this.importedFiles);
        }
        int idx = fileName.lastIndexOf(33);
        String suf = null;
        if (idx != -1) {
            suf = fileName.substring(idx + 1);
            fileName = fileName.substring(0, idx);
        }
        if (!(f2 = new FileWithSuffix(this.importedFiles, PreprocessorInclude3.withEnvironmentVariable(fileName), suf)).fileOk()) {
            Log.error("Current path is " + FileWithSuffix.getAbsolutePath(new File(".")));
            Log.error("Cannot include " + f2.getDescription());
            return new ReadLineSingle(s.withErrorPreprocessor("Cannot include " + f2.getDescription()));
        }
        if (allowMany == PreprocessorIncludeStrategy.ONCE && this.filesUsedCurrent.contains(f2)) {
            return new ReadLineEmpty();
        }
        this.filesUsedCurrent.add(f2);
        this.filesUsedGlobal.add(f2);
        return new Preprocessor2(this.config, this.getReaderInclude(f2, s), this.charset, this.defines, this.definitionsContainer, this.filesUsedGlobal, this.importedFiles.withCurrentDir(f2.getParentFile()));
    }

    public static String withEnvironmentVariable(String s) {
        Pattern p = Pattern.compile("%(\\w+)%");
        Matcher m = p.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String var = m.group(1);
            String value = PreprocessorInclude3.getenv(var);
            if (value == null) continue;
            m.appendReplacement(sb, Matcher.quoteReplacement(value));
        }
        m.appendTail(sb);
        s = sb.toString();
        return s;
    }

    public static String getenv(String var) {
        String env = System.getProperty(var);
        if (StringUtils.isNotEmpty(env)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(env);
        }
        String getenv = System.getenv(var);
        if (StringUtils.isNotEmpty(getenv)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(getenv);
        }
        return null;
    }

    private InputStream getStdlibInputStream(String filename) {
        InputStream result = Stdlib.getResourceAsStream(filename);
        return result;
    }

    private ReadLine getReaderStdlibInclude(CharSequence2 s, String filename) {
        Log.info("Loading sdlib " + filename);
        InputStream is = this.getStdlibInputStream(filename);
        if (is == null) {
            return null;
        }
        String description = "<" + filename + ">";
        try {
            if (StartDiagramExtractReader.containsStartDiagram(is, s, description)) {
                is = this.getStdlibInputStream(filename);
                return StartDiagramExtractReader.build(is, s, description);
            }
            is = this.getStdlibInputStream(filename);
            if (is == null) {
                return null;
            }
            return ReadLineReader.create(new InputStreamReader(is), description);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ReadLineSimple(s, e.toString());
        }
    }

    private ReadLine getReaderInclude(FileWithSuffix f2, CharSequence2 s) {
        try {
            if (StartDiagramExtractReader.containsStartDiagram(f2, s, this.charset)) {
                return StartDiagramExtractReader.build(f2, s, this.charset);
            }
            Reader reader = f2.getReader(this.charset);
            if (reader == null) {
                return new ReadLineSimple(s, "Cannot open " + f2.getDescription());
            }
            return ReadLineReader.create(reader, f2.getDescription(), s.getLocation());
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ReadLineSimple(s, e.toString());
        }
    }

    private ReadLine getReaderInclude(URL url, CharSequence2 s, String suf) {
        try {
            if (StartDiagramExtractReader.containsStartDiagram(url, s, this.charset)) {
                return StartDiagramExtractReader.build(url, s, suf, this.charset);
            }
            InputStream is = url.openStream();
            if (this.charset == null) {
                Log.info("Using default charset");
                return ReadLineReader.create(new InputStreamReader(is), url.toString(), s.getLocation());
            }
            Log.info("Using charset " + this.charset);
            return ReadLineReader.create(new InputStreamReader(is, this.charset), url.toString(), s.getLocation());
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ReadLineSimple(s, e.toString());
        }
    }

    public Set<FileWithSuffix> getFilesUsedGlobal() {
        return this.filesUsedGlobal;
    }

    class Inner
    extends ReadLineInsertable {
        final ReadLine source;

        Inner(ReadLine source) {
            this.source = source;
        }

        @Override
        void closeInternal() throws IOException {
            this.source.close();
        }

        @Override
        CharSequence2 readLineInternal() throws IOException {
            CharSequence2 s = this.source.readLine();
            if (s == null || s.getPreprocessorError() != null) {
                return s;
            }
            if (s != null && StartUtils.startOrEnd(s)) {
                PreprocessorInclude3.this.filesUsedCurrent.clear();
                PreprocessorInclude3.this.strategy = PreprocessorIncludeStrategy.ONCE;
                return s;
            }
            if (s.getPreprocessorError() == null && OptionFlags.ALLOW_INCLUDE) {
                Matcher2 m0 = importPattern.matcher(s);
                if (m0.find()) {
                    CharSequence2 err = PreprocessorInclude3.this.manageFileImport(s, m0);
                    if (err != null) {
                        this.insert(new ReadLineSingle(err));
                    }
                    return this.readLine();
                }
                Matcher2 m1 = includePattern.matcher(s);
                if (m1.find()) {
                    this.insert(PreprocessorInclude3.this.manageFileInclude(s, m1, PreprocessorInclude3.this.strategy));
                    return this.readLine();
                }
                Matcher2 m2 = includeManyPattern.matcher(s);
                if (m2.find()) {
                    this.insert(PreprocessorInclude3.this.manageFileInclude(s, m2, PreprocessorIncludeStrategy.MANY));
                    return this.readLine();
                }
                Matcher2 m3 = includeOncePattern.matcher(s);
                if (m3.find()) {
                    this.insert(PreprocessorInclude3.this.manageFileInclude(s, m3, PreprocessorIncludeStrategy.ONCE));
                    return this.readLine();
                }
                Matcher2 m4 = includeDefPattern.matcher(s);
                if (m4.find()) {
                    this.insert(PreprocessorInclude3.this.manageDefinitionInclude(s, m4));
                    return this.readLine();
                }
            } else {
                Matcher2 m1 = includePatternStdlib.matcher(s);
                if (m1.find()) {
                    this.insert(PreprocessorInclude3.this.manageFileInclude(s, m1, PreprocessorIncludeStrategy.ONCE));
                    return this.readLine();
                }
            }
            Matcher2 mUrl = includeURLPattern.matcher(s);
            if (s.getPreprocessorError() == null && mUrl.find()) {
                this.insert(PreprocessorInclude3.this.manageUrlInclude(s, mUrl));
                return this.readLine();
            }
            Matcher2 m2 = includeDefaultStrategy.matcher(s);
            if (m2.find()) {
                PreprocessorInclude3.this.strategy = PreprocessorIncludeStrategy.fromString(m2.group(1));
                return this.readLine();
            }
            return s;
        }
    }
}

