/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.svg;

import java.io.IOException;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.svg.SvgGraphics;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;

public class DriverImagePng
implements UDriver<SvgGraphics> {
    private final ClipContainer clipContainer;

    public DriverImagePng(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper, UParam param, SvgGraphics svg) {
        UImage image = (UImage)ushape;
        UClip clip = this.clipContainer.getClip();
        if (clip != null) {
            if (!clip.isInside(x, y)) {
                return;
            }
            if (!clip.isInside(x + image.getWidth(), y + image.getHeight())) {
                return;
            }
        }
        try {
            svg.svgImage(image.getImage(), x, y);
        }
        catch (IOException e) {
            Log.error("Error in svg for image " + e);
        }
    }
}

