/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.tikz;

import net.sourceforge.plantuml.tikz.TikzGraphics;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;

public class DriverEllipseTikz
implements UDriver<TikzGraphics> {
    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper, UParam param, TikzGraphics tikz) {
        UEllipse shape = (UEllipse)ushape;
        double width = shape.getWidth();
        double height = shape.getHeight();
        double start = shape.getStart();
        double extend = shape.getExtend();
        double cx = x + width / 2.0;
        double cy = y + height / 2.0;
        tikz.setFillColor(mapper.getMappedColor(param.getBackcolor()));
        tikz.setStrokeColor(mapper.getMappedColor(param.getColor()));
        tikz.setStrokeWidth(param.getStroke().getThickness(), param.getStroke().getDashTikz());
        if (start != 0.0 || extend != 0.0) {
            throw new UnsupportedOperationException();
        }
        tikz.ellipse(cx, cy, width / 2.0, height / 2.0);
    }
}

