/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.svg;

import java.awt.geom.Line2D;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.svg.SvgGraphics;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;

public class DriverLineSvg
implements UDriver<SvgGraphics> {
    private final ClipContainer clipContainer;

    public DriverLineSvg(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper, UParam param, SvgGraphics svg) {
        HtmlColor color;
        ULine shape = (ULine)ushape;
        double x2 = x + shape.getDX();
        double y2 = y + shape.getDY();
        UClip clip = this.clipContainer.getClip();
        if (clip != null) {
            Line2D.Double line = clip.getClippedLine(new Line2D.Double(x, y, x2, y2));
            if (line == null) {
                return;
            }
            x = line.x1;
            y = line.y1;
            x2 = line.x2;
            y2 = line.y2;
        }
        if ((color = param.getColor()) instanceof HtmlColorGradient) {
            HtmlColorGradient gr = (HtmlColorGradient)color;
            svg.setStrokeColor(StringUtils.getAsSvg(mapper, gr.getColor1()));
        } else {
            svg.setStrokeColor(StringUtils.getAsSvg(mapper, color));
        }
        svg.setStrokeWidth(param.getStroke().getThickness(), param.getStroke().getDasharraySvg());
        svg.svgLine(x, y, x2, y2, shape.getDeltaShadow());
    }
}

