/*
 * Decompiled with CFR 0.152.
 */
package smetana.core;

import h.ST_Ppoly_t;
import h.ST_pointf;
import h.htmllabel_t;
import java.lang.reflect.Field;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import smetana.core.JUtils;

public class CType {
    private final String type;

    CType(String type) {
        this.type = type;
        if (type.equals("void")) {
            throw new IllegalArgumentException();
        }
    }

    public boolean isInteger() {
        return this.type.equals("int") || this.type.equals("packval_t");
    }

    public boolean isChar() {
        return this.type.equals("char");
    }

    public boolean isBoolean() {
        return this.type.equals("boolean");
    }

    public boolean isDoubleOrFloat() {
        return this.type.equals("double") || this.type.equals("float");
    }

    public boolean isShort() {
        return this.type.equals("short");
    }

    public boolean isLong() {
        return this.type.equals("long");
    }

    public boolean isEnum() {
        JUtils.LOG("IS ENUM " + this);
        if (this.functionPointer() || this.isVoidStar() || this.isInteger() || this.isChar() || this.isCString() || this.isBoolean() || this.isDoubleOrFloat() || this.isShort() || this.isLong()) {
            return false;
        }
        if (this.getType().contains("*")) {
            return false;
        }
        if (this.getType().contains("[")) {
            return false;
        }
        Class cl = this.getTypeClass();
        if (cl == null) {
            return false;
        }
        List<String> def = CType.getDefinition(cl);
        JUtils.LOG("def3=" + def);
        return def.get(0).equals("typedef enum");
    }

    public String toString() {
        return "CTYPE:" + this.type;
    }

    public Class getTypeClass() {
        if (this.isPrimitive()) {
            return null;
        }
        if (this.type.equals("ST_Ppolyline_t")) {
            return ST_Ppoly_t.class;
        }
        if (this.type.equals("Ppolyline_t")) {
            return ST_Ppoly_t.class;
        }
        return CType.getClassFrom(this.type);
    }

    public static Class getClassFrom(String type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (type.equals("h.pointf_s")) {
            return ST_pointf.class;
        }
        if (type.equals("pointf_s")) {
            return ST_pointf.class;
        }
        if (type.endsWith("htmllabel_t")) {
            return htmllabel_t.class;
        }
        try {
            Class<?> result = Class.forName("h." + type);
            List<String> definition = CType.getDefinition(result);
            if (definition.size() != 1) {
                return result;
            }
            String single = definition.get(0);
            Pattern p1 = Pattern.compile("^typedef\\s+struct\\s+(\\w+)\\s+(\\w+)$");
            Matcher m1 = p1.matcher(single);
            if (!m1.find()) {
                throw new IllegalStateException(single);
            }
            if (!m1.group(2).equals(type)) {
                throw new IllegalStateException(single);
            }
            return CType.getClassFrom(m1.group(1));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<String> getDefinition() {
        return CType.getDefinition(this.getTypeClass());
    }

    static List<String> getDefinition(Class inter) {
        try {
            if (inter == null) {
                return null;
            }
            Field field = inter.getField("DEFINITION");
            return (List)field.get(null);
        }
        catch (NoSuchFieldException e) {
            System.err.println("inter=" + inter);
            e.printStackTrace();
            throw new UnsupportedOperationException();
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException();
        }
    }

    public boolean functionPointer() {
        if (this.isPrimitive()) {
            return false;
        }
        boolean result = this.type.matches("^.*(\\(\\*(\\w+)\\)).*$");
        if (result) {
            return true;
        }
        try {
            List<String> definition = CType.getDefinition(Class.forName("h." + this.type));
            JUtils.LOG("def=" + definition);
            if (definition.size() != 1) {
                return false;
            }
            assert (definition.size() == 1);
            result = definition.get(0).matches("^.*(\\(\\*(\\w+)\\)).*$");
            JUtils.LOG("checking " + this.type + " " + result);
            return result;
        }
        catch (ClassNotFoundException e) {
            JUtils.LOG("typeXXX=" + this.type);
            return false;
        }
    }

    public static boolean isPrimitive(String type) {
        return type.equals("char") || type.equals("long") || type.equals("int") || type.equals("packval_t") || type.equals("boolean") || type.equals("double") || type.equals("float") || type.equals("short");
    }

    public boolean isPrimitive() {
        return CType.isPrimitive(this.type);
    }

    public Class getClassFrom() {
        return CType.getClassFrom(this.type);
    }

    public int getArrayLength() {
        Pattern p = Pattern.compile(".*\\[(\\d+)\\]$");
        Matcher m = p.matcher(this.type);
        if (!m.find()) {
            return 0;
        }
        return Integer.parseInt(m.group(1));
    }

    public boolean isIntStar() {
        return "int*".equals(this.type);
    }

    public boolean isDoubleStar() {
        return "double*".equals(this.type);
    }

    public boolean isVoidStar() {
        return "void*".equals(this.type);
    }

    public String getType() {
        return this.type;
    }

    public boolean isCString() {
        return this.type.equals("CString");
    }

    public boolean isArrayOfCString() {
        return this.type.equals("CString[]");
    }

    public boolean containsStar() {
        return this.type.contains("*");
    }
}

