/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.openiconic;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.openiconic.Movement;
import net.sourceforge.plantuml.openiconic.StringDecipher;
import net.sourceforge.plantuml.openiconic.SvgCommand;
import net.sourceforge.plantuml.openiconic.SvgCommandLetter;
import net.sourceforge.plantuml.openiconic.SvgCommandNumber;
import net.sourceforge.plantuml.openiconic.SvgPosition;

public class SvgPath {
    private List<Movement> movements = new ArrayList<Movement>();
    private List<SvgCommand> commands = new ArrayList<SvgCommand>();

    public SvgPath(String path) {
        path = StringDecipher.decipher(path);
        StringTokenizer st = new StringTokenizer(path);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.matches("[a-zA-Z]")) {
                this.commands.add(new SvgCommandLetter(token));
                continue;
            }
            this.commands.add(new SvgCommandNumber(token));
        }
        this.commands = this.insertMissingLetter(this.commands);
        this.checkArguments(this.commands);
        SvgPosition last = new SvgPosition();
        SvgPosition lastMove = new SvgPosition();
        SvgPosition mirrorControlPoint = null;
        Iterator<SvgCommand> iterator = this.commands.iterator();
        while (iterator.hasNext()) {
            Movement movement = new Movement(iterator);
            if ((movement = movement.toAbsoluteUpperCase(last)).getLetter() == 'Z') {
                last = lastMove;
            }
            if (movement.is('S')) {
                movement = movement.mutoToC(mirrorControlPoint);
            }
            this.movements.add(movement);
            if (movement.getLetter() == 'M') {
                lastMove = movement.lastPosition();
            }
            if (movement.lastPosition() != null) {
                last = movement.lastPosition();
            }
            mirrorControlPoint = movement.getMirrorControlPoint();
        }
    }

    private List<SvgCommand> insertMissingLetter(List<SvgCommand> commands) {
        ArrayList<SvgCommand> result = new ArrayList<SvgCommand>();
        Iterator<SvgCommand> it = commands.iterator();
        SvgCommandLetter lastLetter = null;
        while (it.hasNext()) {
            int nb;
            SvgCommand cmd = it.next();
            if (cmd instanceof SvgCommandNumber) {
                result.add(lastLetter);
                result.add(cmd);
                nb = lastLetter.argumentNumber() - 1;
            } else {
                result.add(cmd);
                lastLetter = ((SvgCommandLetter)cmd).implicit();
                nb = lastLetter.argumentNumber();
            }
            for (int i = 0; i < nb; ++i) {
                SvgCommandNumber number = (SvgCommandNumber)it.next();
                result.add(number);
            }
        }
        return result;
    }

    private void checkArguments(List<SvgCommand> commands) {
        Iterator<SvgCommand> it = commands.iterator();
        while (it.hasNext()) {
            SvgCommandLetter cmd = (SvgCommandLetter)it.next();
            int nb = cmd.argumentNumber();
            for (int i = 0; i < nb; ++i) {
                SvgCommandNumber svgCommandNumber = (SvgCommandNumber)it.next();
            }
        }
    }

    public String toSvg() {
        StringBuilder result = new StringBuilder("<path d=\"");
        for (Movement move : this.movements) {
            result.append(move.toSvg());
            result.append(' ');
        }
        result.append("\"/>");
        return result.toString();
    }

    private UPath toUPath(double factorx, double factory) {
        UPath result = UPath.none();
        Movement previous = null;
        for (Movement move : this.movements) {
            char letter = move.getLetter();
            SvgPosition position = move.lastPosition();
            if (letter == 'M') {
                result.moveTo(position.getXDouble() * factorx, position.getYDouble() * factory);
                continue;
            }
            if (letter == 'C') {
                SvgPosition ctl1 = move.getSvgPosition(0);
                SvgPosition ctl2 = move.getSvgPosition(2);
                result.cubicTo(ctl1.getXDouble() * factorx, ctl1.getYDouble() * factory, ctl2.getXDouble() * factorx, ctl2.getYDouble() * factory, position.getXDouble() * factorx, position.getYDouble() * factory);
                continue;
            }
            if (letter == 'Q') {
                SvgPosition ctl = move.getSvgPosition(0);
                result.cubicTo(ctl.getXDouble() * factorx, ctl.getYDouble() * factory, ctl.getXDouble() * factorx, ctl.getYDouble() * factory, position.getXDouble() * factorx, position.getYDouble() * factory);
                continue;
            }
            if (letter == 'T') {
                if (previous.getLetter() != 'Q') {
                    throw new IllegalArgumentException();
                }
                SvgPosition lastCtl = previous.getSvgPosition(0);
                SvgPosition lastP = previous.lastPosition();
                SvgPosition ctl = lastP.getMirror(lastCtl);
                result.cubicTo(ctl.getXDouble() * factorx, ctl.getYDouble() * factory, ctl.getXDouble() * factorx, ctl.getYDouble() * factory, position.getXDouble() * factorx, position.getYDouble() * factory);
                continue;
            }
            if (letter == 'L') {
                result.lineTo(position.getXDouble() * factorx, position.getYDouble() * factory);
                continue;
            }
            if (letter == 'A') {
                double rx = move.getArgument(0);
                double ry = move.getArgument(1);
                double x_axis_rotation = move.getArgument(2);
                double large_arc_flag = move.getArgument(3);
                double sweep_flag = move.getArgument(4);
                result.arcTo(rx * factorx, ry * factory, x_axis_rotation, large_arc_flag, sweep_flag, position.getXDouble() * factorx, position.getYDouble() * factory);
                continue;
            }
            if (letter == 'Z') {
                result.closePath();
                continue;
            }
            throw new UnsupportedOperationException("letter " + letter);
        }
        result.setOpenIconic(true);
        return result;
    }

    private UPath toUPath(AffineTransform at) {
        UPath result = UPath.none();
        Movement previous = null;
        for (Movement move : this.movements) {
            char letter = move.getLetter();
            SvgPosition position = move.lastPosition();
            if (letter == 'M') {
                result.moveTo(position.affine(at));
            } else if (letter == 'C') {
                SvgPosition ctl1 = move.getSvgPosition(0);
                SvgPosition ctl2 = move.getSvgPosition(2);
                result.cubicTo(ctl1.affine(at), ctl2.affine(at), position.affine(at));
            } else if (letter == 'Q') {
                SvgPosition ctl = move.getSvgPosition(0);
                result.cubicTo(ctl.affine(at), ctl.affine(at), position.affine(at));
            } else if (letter == 'T') {
                if (previous.getLetter() != 'Q') {
                    throw new IllegalArgumentException();
                }
                SvgPosition lastCtl = previous.getSvgPosition(0);
                SvgPosition lastP = previous.lastPosition();
                SvgPosition ctl = lastP.getMirror(lastCtl);
                result.cubicTo(ctl.affine(at), ctl.affine(at), position.affine(at));
            } else if (letter == 'L') {
                result.lineTo(position.affine(at));
            } else if (letter == 'A') {
                double rx = move.getArgument(0);
                double ry = move.getArgument(1);
                double x_axis_rotation = move.getArgument(2);
                double large_arc_flag = move.getArgument(3);
                double sweep_flag = move.getArgument(4);
                XPoint2D tmp = position.affine(at);
                result.arcTo(rx * at.getScaleX(), ry * at.getScaleY(), x_axis_rotation, large_arc_flag, sweep_flag, tmp.getX(), tmp.getY());
            } else if (letter == 'Z') {
                result.closePath();
            } else {
                throw new UnsupportedOperationException("letter " + letter);
            }
            previous = move;
        }
        result.setOpenIconic(true);
        return result;
    }

    public void drawMe(UGraphic ug, double factor) {
        UPath path = this.toUPath(factor, factor);
        ug.draw(path);
    }

    public void drawMe(UGraphic ug, AffineTransform at) {
        UPath path = this.toUPath(at);
        ug.draw(path);
    }
}

