/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.svg;

import java.awt.geom.AffineTransform;
import org.apache.fop.render.intermediate.IFUtil;

public final class SVGUtil {
    private SVGUtil() {
    }

    public static String formatMptToPt(int mpt) {
        return Float.toString((float)mpt / 1000.0f);
    }

    public static String formatMptArrayToPt(int[] lengths) {
        return IFUtil.toString((int[])lengths);
    }

    public static String formatAffineTransformMptToPt(AffineTransform transform) {
        AffineTransform scaled = new AffineTransform(transform);
        scaled.setToTranslation(transform.getTranslateX() / 1000.0, transform.getTranslateY() / 1000.0);
        return IFUtil.toString((AffineTransform)scaled);
    }

    public static String formatAffineTransformsMptToPt(AffineTransform[] transforms) {
        StringBuffer sb = new StringBuffer();
        int c = transforms.length;
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(SVGUtil.formatAffineTransformMptToPt(transforms[i]));
        }
        return sb.toString();
    }
}

