/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.geom;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.AbstractPlacementStrategy;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;

public class PlacementStrategyVisibility
extends AbstractPlacementStrategy {
    private final int col2;

    public PlacementStrategyVisibility(StringBounder stringBounder, int col2) {
        super(stringBounder);
        this.col2 = col2;
    }

    @Override
    public Map<TextBlock, XPoint2D> getPositions(double width, double height) {
        LinkedHashMap<TextBlock, XPoint2D> result = new LinkedHashMap<TextBlock, XPoint2D>();
        double y = 0.0;
        Iterator<Map.Entry<TextBlock, XDimension2D>> it = this.getDimensions().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<TextBlock, XDimension2D> ent1 = it.next();
            Map.Entry<TextBlock, XDimension2D> ent2 = it.next();
            double height1 = ent1.getValue().getHeight();
            double height2 = ent2.getValue().getHeight();
            double maxHeight12 = Math.max(height1, height2);
            result.put(ent1.getKey(), new XPoint2D(0.0, 2.0 + y + (maxHeight12 - height1) / 2.0));
            result.put(ent2.getKey(), new XPoint2D(this.col2, y + (maxHeight12 - height2) / 2.0));
            y += maxHeight12;
        }
        return result;
    }
}

