/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.abel.LinkArg;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.decoration.LinkDecor;
import net.sourceforge.plantuml.decoration.LinkType;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.skin.ColorParam;
import net.sourceforge.plantuml.stereo.Stereotag;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.url.UrlBuilder;
import net.sourceforge.plantuml.url.UrlMode;
import net.sourceforge.plantuml.utils.BlocLines;
import net.sourceforge.plantuml.utils.Position;

public final class CommandFactoryTipOnEntity
implements SingleMultiFactoryCommand<AbstractEntityDiagram> {
    private final IRegex partialPattern;
    private final String key;

    public CommandFactoryTipOnEntity(String key, IRegex partialPattern) {
        this.partialPattern = partialPattern;
        this.key = key;
    }

    private RegexConcat getRegexConcatMultiLine(IRegex partialPattern, boolean withBracket) {
        if (withBracket) {
            return RegexConcat.build(CommandFactoryTipOnEntity.class.getName() + this.key + withBracket, RegexLeaf.start(), new RegexLeaf("note"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("POSITION", "(right|left)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("of"), RegexLeaf.spaceOneOrMore(), partialPattern, RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS1", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS2", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\{"), RegexLeaf.end());
        }
        return RegexConcat.build(CommandFactoryTipOnEntity.class.getName() + this.key + withBracket, RegexLeaf.start(), new RegexLeaf("note"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("POSITION", "(right|left)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("of"), RegexLeaf.spaceOneOrMore(), partialPattern, RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS1", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS2", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    public Command<AbstractEntityDiagram> createSingleLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Command<AbstractEntityDiagram> createMultiLine(final boolean withBracket) {
        return new CommandMultilines2<AbstractEntityDiagram>((IRegex)this.getRegexConcatMultiLine(this.partialPattern, withBracket), MultilinesStrategy.KEEP_STARTING_QUOTE, Trim.BOTH){

            @Override
            public String getPatternEnd() {
                if (withBracket) {
                    return "^(\\})$";
                }
                return "^[%s]*(end[%s]?note)$";
            }

            @Override
            protected CommandExecutionResult executeNow(AbstractEntityDiagram system, BlocLines lines) throws NoSuchColorException {
                RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
                lines = lines.subExtract(1, 1);
                lines = lines.removeEmptyColumns();
                Url url = null;
                if (line0.get("URL", 0) != null) {
                    UrlBuilder urlBuilder = new UrlBuilder(system.getSkinParam().getValue("topurl"), UrlMode.STRICT);
                    url = urlBuilder.getUrl(line0.get("URL", 0));
                }
                return CommandFactoryTipOnEntity.this.executeInternal(line0, system, url, lines);
            }
        };
    }

    private CommandExecutionResult executeInternal(RegexResult line0, AbstractEntityDiagram diagram, Url url, BlocLines lines) throws NoSuchColorException {
        String pos = line0.get("POSITION", 0);
        String idShort = line0.get("ENTITY", 0);
        String member = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(line0.get("ENTITY", 1));
        Quark<Entity> quark = diagram.quarkInContext(true, idShort);
        Entity cl1 = quark.getData();
        if (cl1 == null) {
            return CommandExecutionResult.error("Nothing to note to");
        }
        Position position = Position.valueOf(StringUtils.goUpperCase(pos)).withRankdir(diagram.getSkinParam().getRankdir());
        String tmp = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(idShort + "$$$" + position.name());
        Quark<Entity> identTip = diagram.quarkInContext(true, tmp);
        Entity tips = identTip.getData();
        if (tips == null) {
            tips = diagram.reallyCreateLeaf(identTip, Display.getWithNewlines(""), LeafType.TIPS, null);
            LinkType type = new LinkType(LinkDecor.NONE, LinkDecor.NONE).getInvisible();
            Link link = position == Position.RIGHT ? new Link(diagram.getEntityFactory(), diagram.getSkinParam().getCurrentStyleBuilder(), cl1, tips, type, LinkArg.noDisplay(1)) : new Link(diagram.getEntityFactory(), diagram.getSkinParam().getCurrentStyleBuilder(), tips, cl1, type, LinkArg.noDisplay(1));
            diagram.addLink(link);
        }
        tips.putTip(member, lines.toDisplay());
        Colors colors = CommandFactoryTipOnEntity.color().getColor(line0, diagram.getSkinParam().getIHtmlColorSet());
        String stereotypeString = line0.get("STEREO", 0);
        Stereotype stereotype = null;
        if (stereotypeString != null) {
            stereotype = Stereotype.build(stereotypeString);
            colors = colors.applyStereotypeForNote(stereotype, diagram.getSkinParam(), ColorParam.noteBackground, ColorParam.noteBorder);
        }
        if (stereotypeString != null) {
            tips.setStereotype(stereotype);
        }
        tips.setColors(colors);
        return CommandExecutionResult.ok();
    }
}

