/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.text;

import java.util.ArrayList;
import java.util.Objects;
import org.stathissideris.ascii2image.text.AbstractCell;
import org.stathissideris.ascii2image.text.CellSet;
import org.stathissideris.ascii2image.text.TextGrid;

public class AbstractionGrid {
    private static final boolean DEBUG = false;
    private TextGrid grid;

    public static AbstractionGrid makeUsingBuffer(TextGrid internalGrid) {
        if (internalGrid.getWidth() % 3 != 0 || internalGrid.getHeight() % 3 != 0) {
            throw new IllegalArgumentException("Passed TextGrid must have dimensions that are divisible by 3.");
        }
        AbstractionGrid result = new AbstractionGrid(internalGrid.getWidth() / 3, internalGrid.getHeight() / 3);
        result.setInternalBuffer(internalGrid);
        return result;
    }

    public AbstractionGrid(TextGrid textGrid, CellSet cellSet) {
        this(textGrid.getWidth(), textGrid.getHeight());
        for (TextGrid.Cell cell : cellSet) {
            if (textGrid.isBlank(cell)) continue;
            if (textGrid.isCross(cell)) {
                this.set(cell.x, cell.y, AbstractCell.makeCross());
                continue;
            }
            if (textGrid.isT(cell)) {
                this.set(cell.x, cell.y, AbstractCell.makeT());
                continue;
            }
            if (textGrid.isK(cell)) {
                this.set(cell.x, cell.y, AbstractCell.makeK());
                continue;
            }
            if (textGrid.isInverseT(cell)) {
                this.set(cell.x, cell.y, AbstractCell.makeInverseT());
                continue;
            }
            if (textGrid.isInverseK(cell)) {
                this.set(cell.x, cell.y, AbstractCell.makeInverseK());
                continue;
            }
            if (textGrid.isCorner1(cell)) {
                this.set(cell.x, cell.y, AbstractCell.makeCorner1());
                continue;
            }
            if (textGrid.isCorner2(cell)) {
                this.set(cell.x, cell.y, AbstractCell.makeCorner2());
                continue;
            }
            if (textGrid.isCorner3(cell)) {
                this.set(cell.x, cell.y, AbstractCell.makeCorner3());
                continue;
            }
            if (textGrid.isCorner4(cell)) {
                this.set(cell.x, cell.y, AbstractCell.makeCorner4());
                continue;
            }
            if (textGrid.isHorizontalLine(cell)) {
                this.set(cell.x, cell.y, AbstractCell.makeHorizontalLine());
                continue;
            }
            if (textGrid.isVerticalLine(cell)) {
                this.set(cell.x, cell.y, AbstractCell.makeVerticalLine());
                continue;
            }
            if (textGrid.isCrossOnLine(cell)) {
                this.set(cell.x, cell.y, AbstractCell.makeCross());
                continue;
            }
            if (!textGrid.isStarOnLine(cell)) continue;
            this.set(cell.x, cell.y, AbstractCell.makeStar());
        }
    }

    private AbstractionGrid(int width, int height) {
        this.grid = new TextGrid(width * 3, height * 3);
    }

    public TextGrid getCopyOfInternalBuffer() {
        return new TextGrid(this.grid);
    }

    private void setInternalBuffer(TextGrid grid) {
        this.grid = grid;
    }

    public int getWidth() {
        return this.grid.getWidth() / 3;
    }

    public int getHeight() {
        return this.grid.getHeight() / 3;
    }

    public TextGrid getAsTextGrid() {
        TextGrid result = new TextGrid(this.getWidth(), this.getHeight());
        for (int y = 0; y < this.grid.getHeight(); ++y) {
            for (int x = 0; x < this.grid.getWidth(); ++x) {
                TextGrid textGrid = this.grid;
                Objects.requireNonNull(textGrid);
                TextGrid.Cell cell = textGrid.new TextGrid.Cell(x, y);
                if (this.grid.isBlank(cell)) continue;
                result.set(x / 3, y / 3, '*');
            }
        }
        return result;
    }

    public ArrayList getDistinctShapes() {
        ArrayList<CellSet> result = new ArrayList<CellSet>();
        CellSet nonBlank = this.grid.getAllNonBlank();
        ArrayList distinct = nonBlank.breakIntoDistinctBoundaries();
        for (CellSet set : distinct) {
            AbstractionGrid temp = new AbstractionGrid(this.getWidth(), this.getHeight());
            temp.fillCells(set);
            result.add(temp.getAsTextGrid().getAllNonBlank());
        }
        return result;
    }

    protected void fillCells(CellSet cells) {
        this.grid.fillCellsWith(cells, '*');
    }

    public void set(int xPos, int yPos, AbstractCell cell) {
        xPos *= 3;
        yPos *= 3;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                if (cell.rows[x][y] != 1) continue;
                this.grid.set(xPos + x, yPos + y, '*');
            }
        }
    }
}

