/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.helper;

import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XSingleComponentFactory;
import com.sun.star.lib.uno.helper.ComponentBase;
import com.sun.star.registry.InvalidRegistryException;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.uno.DeploymentException;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class Factory
extends ComponentBase
implements XSingleComponentFactory,
XServiceInfo {
    private static final boolean DEBUG = false;
    private final String m_impl_name;
    private final String[] m_supported_services;
    private final Class<?> m_impl_class;
    private final Method m_method;
    private final Constructor m_ctor;

    public static XSingleComponentFactory createComponentFactory(Class clazz, String string, String[] stringArray) throws RuntimeException {
        return new Factory(clazz, string, stringArray);
    }

    public static XSingleComponentFactory createComponentFactory(Class clazz, String[] stringArray) throws RuntimeException {
        return Factory.createComponentFactory(clazz, clazz.getName(), stringArray);
    }

    public static boolean writeRegistryServiceInfo(String string, String[] stringArray, XRegistryKey xRegistryKey) {
        try {
            XRegistryKey xRegistryKey2 = xRegistryKey.createKey("/" + string + "/UNO/SERVICES");
            for (int i = 0; i < stringArray.length; ++i) {
                xRegistryKey2.createKey(stringArray[i]);
            }
            return true;
        }
        catch (InvalidRegistryException invalidRegistryException) {
            return false;
        }
    }

    private Factory(Class clazz, String string, String[] stringArray) throws DeploymentException {
        this.m_impl_name = string;
        this.m_supported_services = stringArray;
        this.m_impl_class = clazz;
        Class[] classArray = new Class[]{XComponentContext.class};
        if (!Modifier.isPublic(clazz.getModifiers())) {
            throw new DeploymentException("class " + clazz + " is not public");
        }
        Method method = null;
        try {
            method = this.m_impl_class.getMethod("__create", classArray);
            int n = method.getModifiers();
            if (!(method.getReturnType().equals(Object.class) && Modifier.isStatic(n) && Modifier.isPublic(n))) {
                method = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_method = method;
        Constructor<?> constructor = null;
        if (null == this.m_method) {
            try {
                constructor = this.m_impl_class.getConstructor(classArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (constructor != null) {
                if (!Modifier.isPublic(constructor.getModifiers())) {
                    throw new DeploymentException("constructor with XComponentContext param for class  " + clazz + " is not public");
                }
            } else {
                Constructor<?> constructor2;
                try {
                    constructor2 = this.m_impl_class.getConstructor(new Class[0]);
                }
                catch (Exception exception) {
                    throw new DeploymentException((Throwable)exception, "class " + clazz + " has no means of creating it, cannot find a __create method or a useful constructor.");
                }
                if (!Modifier.isPublic(constructor2.getModifiers())) {
                    throw new DeploymentException("default constructor for class  " + clazz + " is not public");
                }
            }
        }
        this.m_ctor = constructor;
    }

    private Object instantiate(XComponentContext xComponentContext) throws com.sun.star.uno.Exception {
        try {
            if (null != this.m_method) {
                return this.m_method.invoke(null, xComponentContext);
            }
            if (null != this.m_ctor) {
                return this.m_ctor.newInstance(xComponentContext);
            }
            return this.m_impl_class.newInstance();
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof java.lang.RuntimeException) {
                throw (java.lang.RuntimeException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof com.sun.star.uno.Exception) {
                throw (com.sun.star.uno.Exception)throwable;
            }
            throw new com.sun.star.uno.Exception(throwable, throwable.getMessage(), (Object)this);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException((Throwable)illegalAccessException, illegalAccessException.getMessage(), (Object)this);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException((Throwable)instantiationException, instantiationException.getMessage(), (Object)this);
        }
    }

    public final Object createInstanceWithContext(XComponentContext xComponentContext) throws com.sun.star.uno.Exception {
        return this.instantiate(xComponentContext);
    }

    public final Object createInstanceWithArgumentsAndContext(Object[] objectArray, XComponentContext xComponentContext) throws com.sun.star.uno.Exception {
        Object object = this.instantiate(xComponentContext);
        XInitialization xInitialization = (XInitialization)UnoRuntime.queryInterface(XInitialization.class, (Object)object);
        if (null == xInitialization) {
            throw new IllegalArgumentException("cannot pass arguments to component; no XInitialization implemented!", (Object)this, 0);
        }
        xInitialization.initialize(objectArray);
        return object;
    }

    public final String getImplementationName() {
        return this.m_impl_name;
    }

    public final boolean supportsService(String string) {
        for (int i = 0; i < this.m_supported_services.length; ++i) {
            if (!this.m_supported_services[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public final String[] getSupportedServiceNames() {
        return this.m_supported_services;
    }
}

