/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.config;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.pentaho.reporting.libraries.base.boot.AbstractBoot;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.ModifiableConfiguration;

public class HierarchicalConfiguration
implements ModifiableConfiguration {
    private static final long serialVersionUID = -6962432361197107831L;
    private Properties configuration = new Properties();
    private Class booterClass;
    private transient Configuration parentConfiguration;

    public HierarchicalConfiguration() {
    }

    public HierarchicalConfiguration(Configuration parentConfiguration) {
        this();
        this.parentConfiguration = parentConfiguration;
    }

    public HierarchicalConfiguration(Class booterClass) {
        this();
        this.booterClass = booterClass;
    }

    @Override
    public String getConfigProperty(String key) {
        return this.getConfigProperty(key, null);
    }

    @Override
    public String getConfigProperty(String key, String defaultValue) {
        String value = this.configuration.getProperty(key);
        if (value == null) {
            value = this.isRootConfig() ? defaultValue : this.parentConfiguration.getConfigProperty(key, defaultValue);
        }
        return value;
    }

    @Override
    public void setConfigProperty(String key, String value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            this.configuration.remove(key);
        } else {
            this.configuration.setProperty(key, value);
        }
    }

    private boolean isRootConfig() {
        return this.parentConfiguration == null;
    }

    public boolean isLocallyDefined(String key) {
        return this.configuration.containsKey(key);
    }

    protected Properties getConfiguration() {
        return this.configuration;
    }

    public void insertConfiguration(HierarchicalConfiguration config) {
        if (config == null) {
            throw new NullPointerException("Configuration that should be inserted is null");
        }
        config.setParentConfig(this.getParentConfig());
        this.setParentConfig(config);
    }

    protected void setParentConfig(Configuration config) {
        if (this.parentConfiguration == this) {
            throw new IllegalArgumentException("Cannot add myself as parent configuration.");
        }
        this.parentConfiguration = config;
    }

    protected Configuration getParentConfig() {
        return this.parentConfiguration;
    }

    @Override
    public Enumeration getConfigProperties() {
        return this.configuration.keys();
    }

    @Override
    public Iterator findPropertyKeys(String prefix) {
        if (prefix == null) {
            throw new NullPointerException("Prefix must not be null");
        }
        HashSet keys = new HashSet();
        this.collectPropertyKeys(prefix, this, keys);
        Object[] objects = keys.toArray();
        Arrays.sort(objects);
        return Arrays.asList(objects).iterator();
    }

    private void collectPropertyKeys(String prefix, Configuration config, Set collector) {
        Enumeration enum1 = config.getConfigProperties();
        while (enum1.hasMoreElements()) {
            String key = (String)enum1.nextElement();
            if (!key.startsWith(prefix) || collector.contains(key)) continue;
            collector.add(key);
        }
        if (config instanceof HierarchicalConfiguration) {
            HierarchicalConfiguration hconfig = (HierarchicalConfiguration)config;
            if (hconfig.parentConfiguration != null) {
                this.collectPropertyKeys(prefix, hconfig.parentConfiguration, collector);
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.parentConfiguration instanceof HierarchicalConfiguration) {
            HierarchicalConfiguration parent = (HierarchicalConfiguration)this.parentConfiguration;
            if (parent.booterClass != null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeObject(this.parentConfiguration);
            }
        } else if (this.parentConfiguration != null) {
            out.writeBoolean(true);
            out.writeObject(this.parentConfiguration);
        } else {
            out.writeBoolean(false);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        boolean readParent = in.readBoolean();
        if (readParent) {
            this.parentConfiguration = (ModifiableConfiguration)in.readObject();
        } else if (this.booterClass != null) {
            AbstractBoot boot = AbstractBoot.loadBooter(this.booterClass.getName(), this.booterClass);
            this.parentConfiguration = boot.getGlobalConfig();
        } else {
            this.parentConfiguration = null;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        HierarchicalConfiguration config = (HierarchicalConfiguration)super.clone();
        config.configuration = (Properties)this.configuration.clone();
        return config;
    }
}

