/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.file.FileContentEntity;
import org.pentaho.reporting.libraries.repository.file.FileRepository;

public class FileContentItem
extends FileContentEntity
implements ContentItem {
    private static final long serialVersionUID = 5080072160607835550L;

    public FileContentItem(ContentLocation parent, File backend) {
        super(parent, backend);
    }

    @Override
    public String getMimeType() throws ContentIOException {
        FileRepository fileRepository = (FileRepository)this.getRepository();
        return fileRepository.getMimeRegistry().getMimeType(this);
    }

    @Override
    public OutputStream getOutputStream() throws ContentIOException, IOException {
        return new FileOutputStream(this.getBackend());
    }

    @Override
    public InputStream getInputStream() throws ContentIOException, IOException {
        return new FileInputStream(this.getBackend());
    }

    @Override
    public boolean isReadable() {
        return this.getBackend().canRead();
    }

    @Override
    public boolean isWriteable() {
        return this.getBackend().canWrite();
    }
}

