/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler.font;

import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.font.FontFamilyValues;
import org.jfree.layouting.input.style.parser.stylehandler.ListOfValuesReadHandler;
import org.jfree.layouting.input.style.values.CSSStringType;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public class FontFamilyReadHandler
extends ListOfValuesReadHandler {
    @Override
    public CSSValue createValue(StyleKey styleKey, LexicalUnit lexicalUnit) {
        if (lexicalUnit.getLexicalUnitType() == 35 && "none".equalsIgnoreCase(lexicalUnit.getStringValue())) {
            return FontFamilyValues.NONE;
        }
        return super.createValue(styleKey, lexicalUnit);
    }

    @Override
    protected CSSValue parseValue(LexicalUnit lexicalUnit) {
        if (lexicalUnit.getLexicalUnitType() == 35) {
            if ("serif".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return FontFamilyValues.SERIF;
            }
            if ("sans-serif".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return FontFamilyValues.SANS_SERIF;
            }
            if ("fantasy".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return FontFamilyValues.FANTASY;
            }
            if ("fantasy".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return FontFamilyValues.CURSIVE;
            }
            if ("monospace".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return FontFamilyValues.MONOSPACE;
            }
            return null;
        }
        if (lexicalUnit.getLexicalUnitType() == 36) {
            return new CSSStringValue(CSSStringType.STRING, lexicalUnit.getStringValue());
        }
        return null;
    }
}

