/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.InlineRenderBox;
import org.jfree.layouting.renderer.model.NormalFlowRenderBox;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;

public abstract class IterateVisualProcessStep {
    protected IterateVisualProcessStep() {
    }

    protected final void startProcessing(RenderNode renderNode) {
        RenderBox renderBox = renderNode.getParent();
        if (renderBox == null || renderBox instanceof BlockRenderBox) {
            this.processBlockLevelChild(renderNode);
        } else if (renderBox instanceof InlineRenderBox) {
            this.processInlineLevelChild(renderNode);
        } else {
            this.processOtherLevelChild(renderNode);
        }
    }

    protected void processOtherLevelChild(RenderNode renderNode) {
    }

    protected void processInlineLevelNode(RenderNode renderNode) {
    }

    protected boolean startInlineLevelBox(RenderBox renderBox) {
        return true;
    }

    protected void finishInlineLevelBox(RenderBox renderBox) {
    }

    protected void processInlineLevelChild(RenderNode renderNode) {
        if (renderNode instanceof ParagraphRenderBox) {
            ParagraphRenderBox paragraphRenderBox = (ParagraphRenderBox)renderNode;
            if (this.startInlineLevelBox(paragraphRenderBox)) {
                this.processParagraphChilds(paragraphRenderBox);
            }
            this.finishInlineLevelBox(paragraphRenderBox);
        } else if (renderNode instanceof RenderBox) {
            RenderBox renderBox = (RenderBox)renderNode;
            if (this.startInlineLevelBox(renderBox)) {
                this.processBoxChilds(renderBox);
            }
            this.finishInlineLevelBox(renderBox);
        } else {
            this.processInlineLevelNode(renderNode);
        }
    }

    protected void processBlockLevelNode(RenderNode renderNode) {
    }

    protected boolean startBlockLevelBox(RenderBox renderBox) {
        return true;
    }

    protected void finishBlockLevelBox(RenderBox renderBox) {
    }

    protected void processBlockLevelChild(RenderNode renderNode) {
        if (renderNode instanceof LogicalPageBox) {
            LogicalPageBox logicalPageBox = (LogicalPageBox)renderNode;
            if (this.startBlockLevelBox(logicalPageBox)) {
                this.startProcessing(logicalPageBox.getHeaderArea());
                this.processBoxChilds(logicalPageBox);
                this.startProcessing(logicalPageBox.getFooterArea());
            }
            this.finishBlockLevelBox(logicalPageBox);
        } else if (renderNode instanceof NormalFlowRenderBox) {
            NormalFlowRenderBox normalFlowRenderBox = (NormalFlowRenderBox)renderNode;
            NormalFlowRenderBox[] normalFlowRenderBoxArray = normalFlowRenderBox.getFlows();
            for (int i = 0; i < normalFlowRenderBoxArray.length; ++i) {
                NormalFlowRenderBox normalFlowRenderBox2 = normalFlowRenderBoxArray[i];
                this.processFlow(normalFlowRenderBox2);
            }
            this.processFlow(normalFlowRenderBox);
        } else if (renderNode instanceof ParagraphRenderBox) {
            ParagraphRenderBox paragraphRenderBox = (ParagraphRenderBox)renderNode;
            if (this.startBlockLevelBox(paragraphRenderBox)) {
                this.processParagraphChilds(paragraphRenderBox);
            }
            this.finishBlockLevelBox(paragraphRenderBox);
        } else if (renderNode instanceof RenderBox) {
            RenderBox renderBox = (RenderBox)renderNode;
            if (this.startBlockLevelBox(renderBox)) {
                this.processBoxChilds(renderBox);
            }
            this.finishBlockLevelBox(renderBox);
        } else {
            this.processBlockLevelNode(renderNode);
        }
    }

    protected void processFlow(NormalFlowRenderBox normalFlowRenderBox) {
        if (this.startBlockLevelBox(normalFlowRenderBox)) {
            this.processBoxChilds(normalFlowRenderBox);
        }
        this.finishBlockLevelBox(normalFlowRenderBox);
    }

    protected abstract void processParagraphChilds(ParagraphRenderBox var1);

    protected void processBoxChilds(RenderBox renderBox) {
        for (RenderNode renderNode = renderBox.getFirstChild(); renderNode != null; renderNode = renderNode.getNext()) {
            this.startProcessing(renderNode);
        }
    }
}

