/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.modules.cache.ehcache;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.cache.CachingResourceData;
import org.pentaho.reporting.libraries.resourceloader.cache.DefaultResourceDataCacheEntry;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceDataCache;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceDataCacheEntry;
import org.pentaho.reporting.libraries.resourceloader.modules.cache.ehcache.EHCacheModule;

public class EHResourceDataCache
implements ResourceDataCache {
    private Cache dataCache;

    public EHResourceDataCache(Cache dataCache) {
        if (dataCache == null) {
            throw new NullPointerException();
        }
        this.dataCache = dataCache;
    }

    @Override
    public ResourceDataCacheEntry get(ResourceKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        try {
            Element element = this.dataCache.get((Object)key);
            if (element != null) {
                if (EHCacheModule.CACHE_MONITOR.isDebugEnabled()) {
                    EHCacheModule.CACHE_MONITOR.debug((Object)("Data Cache Hit  " + key));
                }
                return (ResourceDataCacheEntry)element.getObjectValue();
            }
            if (EHCacheModule.CACHE_MONITOR.isDebugEnabled()) {
                EHCacheModule.CACHE_MONITOR.debug((Object)("Data Cache Miss " + key));
            }
            return null;
        }
        catch (CacheException e) {
            return null;
        }
    }

    @Override
    public ResourceData put(ResourceManager caller, ResourceData data) throws ResourceLoadingException {
        if (data == null) {
            throw new NullPointerException();
        }
        if (caller == null) {
            throw new NullPointerException();
        }
        ResourceData cdata = CachingResourceData.createCached(data);
        ResourceKey keyObject = data.getKey();
        DefaultResourceDataCacheEntry dataCacheEntry = new DefaultResourceDataCacheEntry(cdata, caller);
        this.dataCache.put(new Element((Object)keyObject, (Object)dataCacheEntry));
        return cdata;
    }

    @Override
    public void remove(ResourceData data) {
        if (data == null) {
            throw new NullPointerException();
        }
        this.dataCache.remove((Object)data.getKey());
    }

    @Override
    public void clear() {
        try {
            this.dataCache.removeAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void shutdown() {
        try {
            this.dataCache.getCacheManager().shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

