/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process.valign;

import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.process.valign.AlignContext;
import org.jfree.layouting.renderer.text.ExtendedBaselineInfo;

public class InlineBlockAlignContext
extends AlignContext {
    private long[] baselines;
    private long baselineShift;

    public InlineBlockAlignContext(RenderBox renderBox) {
        super(renderBox);
        ExtendedBaselineInfo extendedBaselineInfo = renderBox.getBaselineInfo();
        this.baselines = extendedBaselineInfo.getBaselines();
        this.setDominantBaseline(extendedBaselineInfo.getDominantBaseline());
    }

    @Override
    public long getBaselineDistance(int n) {
        return this.baselines[n] - this.baselines[this.getDominantBaseline()] + this.baselineShift;
    }

    @Override
    public void shift(long l) {
        this.baselineShift += l;
    }

    @Override
    public long getAfterEdge() {
        return this.baselines[9] + this.baselineShift;
    }

    @Override
    public long getBeforeEdge() {
        return this.baselines[0] + this.baselineShift;
    }
}

