/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.util;

import java.io.Serializable;
import java.util.EmptyStackException;

public class IntList
implements Serializable,
Cloneable {
    private static final int[] EMPTY_ARRAY = new int[0];
    private int[] data;
    private int size;
    private int increment;

    public IntList(int n) {
        this.data = new int[n];
        this.increment = n;
    }

    private void ensureCapacity(int n) {
        if (this.data.length <= n) {
            int[] nArray = new int[Math.max(this.data.length + this.increment, n + 1)];
            System.arraycopy(this.data, 0, nArray, 0, this.size);
            this.data = nArray;
        }
    }

    public void add(int n) {
        this.ensureCapacity(this.size);
        this.data[this.size] = n;
        ++this.size;
    }

    public void set(int n, int n2) {
        this.ensureCapacity(n);
        this.data[n] = n2;
        if (n >= this.size) {
            this.size = n + 1;
        }
    }

    public int get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index " + n + " is invalid");
        }
        return this.data[n];
    }

    public void clear() {
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public int pop() {
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        --this.size;
        return this.data[this.size];
    }

    public int peek() {
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        return this.data[this.size - 1];
    }

    public final void push(int n) {
        this.add(n);
    }

    public int[] toArray() {
        if (this.size == 0) {
            return EMPTY_ARRAY;
        }
        return (int[])this.data.clone();
    }

    public Object clone() throws CloneNotSupportedException {
        IntList intList = (IntList)super.clone();
        intList.data = (int[])this.data.clone();
        return intList;
    }
}

