/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.xhtml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XhtmlDocument
implements Serializable {
    private transient Document document;
    private transient byte[] data;
    private URL source;
    private transient boolean hasErrors;

    public XhtmlDocument(URL uRL, byte[] byArray, Document document) {
        if (uRL == null) {
            throw new NullPointerException();
        }
        this.data = byArray;
        this.source = uRL;
        this.document = document;
    }

    protected byte[] getData() {
        if (this.data == null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                InputStream inputStream = this.source.openStream();
                IOUtils.getInstance().copyStreams(inputStream, (OutputStream)byteArrayOutputStream);
                this.data = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                this.data = new byte[0];
            }
        }
        return this.data;
    }

    public URL getSource() {
        return this.source;
    }

    public Document getDocument() {
        if (this.hasErrors) {
            return null;
        }
        if (this.document == null) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                InputSource inputSource = new InputSource(new ByteArrayInputStream(this.getData()));
                Document document = documentBuilder.parse(inputSource);
                return document;
            }
            catch (Exception exception) {
                this.document = null;
                this.hasErrors = true;
            }
        }
        return this.document;
    }
}

