/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.parser.style;

import java.util.ArrayList;
import java.util.List;
import org.jfree.report.modules.factories.report.flow.SectionReadHandler;
import org.jfree.report.structure.Element;
import org.libreoffice.report.pentaho.model.OfficeStyles;
import org.libreoffice.report.pentaho.parser.ElementReadHandler;
import org.libreoffice.report.pentaho.parser.data.DataStyleReadHandler;
import org.libreoffice.report.pentaho.parser.style.OfficeStyleReadHandler;
import org.libreoffice.report.pentaho.parser.style.PageLayoutReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class OfficeStylesReadHandler
extends ElementReadHandler {
    private final List<OfficeStyleReadHandler> textStyleChildren;
    private final List<DataStyleReadHandler> dataStyleChildren;
    private final List<SectionReadHandler> otherStyleChildren;
    private final List<PageLayoutReadHandler> pageLayoutChildren;
    private final OfficeStyles officeStyles;

    public OfficeStylesReadHandler(OfficeStyles officeStyles) {
        this.officeStyles = officeStyles;
        this.pageLayoutChildren = new ArrayList<PageLayoutReadHandler>();
        this.dataStyleChildren = new ArrayList<DataStyleReadHandler>();
        this.textStyleChildren = new ArrayList<OfficeStyleReadHandler>();
        this.otherStyleChildren = new ArrayList<SectionReadHandler>();
    }

    protected XmlReadHandler getHandlerForChild(String string, String string2, Attributes attributes) throws SAXException {
        if ("urn:oasis:names:tc:opendocument:xmlns:style:1.0".equals(string)) {
            if ("style".equals(string2)) {
                OfficeStyleReadHandler officeStyleReadHandler = new OfficeStyleReadHandler();
                this.textStyleChildren.add(officeStyleReadHandler);
                return officeStyleReadHandler;
            }
            if ("page-layout".equals(string2)) {
                PageLayoutReadHandler pageLayoutReadHandler = new PageLayoutReadHandler();
                this.pageLayoutChildren.add(pageLayoutReadHandler);
                return pageLayoutReadHandler;
            }
        } else if ("urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0".equals(string)) {
            DataStyleReadHandler dataStyleReadHandler = new DataStyleReadHandler(false);
            this.dataStyleChildren.add(dataStyleReadHandler);
            return dataStyleReadHandler;
        }
        SectionReadHandler sectionReadHandler = new SectionReadHandler();
        this.otherStyleChildren.add(sectionReadHandler);
        return sectionReadHandler;
    }

    protected void doneParsing() throws SAXException {
        ElementReadHandler elementReadHandler;
        int n;
        for (n = 0; n < this.textStyleChildren.size(); ++n) {
            elementReadHandler = this.textStyleChildren.get(n);
            this.officeStyles.addStyle(((OfficeStyleReadHandler)elementReadHandler).getOfficeStyle());
        }
        for (n = 0; n < this.pageLayoutChildren.size(); ++n) {
            elementReadHandler = this.pageLayoutChildren.get(n);
            this.officeStyles.addPageStyle(((PageLayoutReadHandler)elementReadHandler).getPageLayout());
        }
        for (n = 0; n < this.dataStyleChildren.size(); ++n) {
            elementReadHandler = this.dataStyleChildren.get(n);
            this.officeStyles.addDataStyle(((DataStyleReadHandler)elementReadHandler).getDataStyle());
        }
        for (n = 0; n < this.otherStyleChildren.size(); ++n) {
            elementReadHandler = this.otherStyleChildren.get(n);
            this.officeStyles.addOtherNode((Element)elementReadHandler.getNode());
        }
    }

    @Override
    public Element getElement() {
        return this.officeStyles;
    }
}

