/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.connections.socket;

import com.sun.star.lang.IllegalArgumentException;

final class ConnectionDescriptor {
    private String host = null;
    private int port = 6001;
    private int backlog = 50;
    private Boolean tcpNoDelay = null;

    public ConnectionDescriptor(String string) throws IllegalArgumentException {
        int n = string.indexOf(44);
        while (n >= 0) {
            int n2 = string.indexOf(44, n + 1);
            int n3 = n2 < 0 ? string.length() : n2;
            int n4 = string.indexOf(61, n + 1);
            if (n4 < 0 || n4 >= n3) {
                throw new IllegalArgumentException("parameter lacks '='");
            }
            String string2 = string.substring(n + 1, n4);
            String string3 = string.substring(n4 + 1, n3);
            if (string2.equalsIgnoreCase("host")) {
                this.host = string3;
            } else if (string2.equalsIgnoreCase("port")) {
                try {
                    this.port = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException((Throwable)numberFormatException);
                }
                if (this.port < 0 || this.port > 65535) {
                    throw new IllegalArgumentException("port parameter must have value between 0 and 65535, inclusive");
                }
            } else if (string2.equalsIgnoreCase("backlog")) {
                try {
                    this.backlog = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException((Throwable)numberFormatException);
                }
            } else if (string2.equalsIgnoreCase("tcpnodelay")) {
                if (string3.equals("0")) {
                    this.tcpNoDelay = Boolean.FALSE;
                } else if (string3.equals("1")) {
                    this.tcpNoDelay = Boolean.TRUE;
                } else {
                    throw new IllegalArgumentException("tcpnodelay parameter must have 0/1 value");
                }
            }
            n = n2;
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public Boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }
}

