/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.output;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.libreoffice.report.DataSourceFactory;
import org.libreoffice.report.ImageService;
import org.libreoffice.report.InputRepository;
import org.libreoffice.report.JobProperties;
import org.libreoffice.report.OutputRepository;
import org.libreoffice.report.ReportExecutionException;
import org.libreoffice.report.ReportJobDefinition;
import org.libreoffice.report.pentaho.DefaultNameGenerator;
import org.libreoffice.report.pentaho.PentahoReportEngine;

public class OleProducer {
    private static final Log LOGGER = LogFactory.getLog(OleProducer.class);
    private final InputRepository inputRepository;
    private final OutputRepository outputRepository;
    private final DefaultNameGenerator nameGenerator;
    private final DataSourceFactory dataSourceFactory;
    private final ImageService imageService;
    private final Integer maxRows;

    public OleProducer(InputRepository inputRepository, OutputRepository outputRepository, ImageService imageService, DataSourceFactory dataSourceFactory, Integer n) {
        if (inputRepository == null) {
            throw new NullPointerException();
        }
        if (outputRepository == null) {
            throw new NullPointerException();
        }
        this.inputRepository = inputRepository;
        this.outputRepository = outputRepository;
        this.nameGenerator = new DefaultNameGenerator(outputRepository);
        this.dataSourceFactory = dataSourceFactory;
        this.imageService = imageService;
        this.maxRows = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String produceOle(String string, List list, List list2, List list3) {
        InputRepository inputRepository = null;
        OutputRepository outputRepository = null;
        String string2 = "";
        try {
            inputRepository = this.inputRepository.openInputRepository(string);
            string2 = this.nameGenerator.generateStorageName("Object", null);
            outputRepository = this.outputRepository.openOutputRepository(string2, "application/vnd.oasis.opendocument.chart");
            try {
                PentahoReportEngine pentahoReportEngine = new PentahoReportEngine();
                ReportJobDefinition reportJobDefinition = pentahoReportEngine.createJobDefinition();
                JobProperties jobProperties = reportJobDefinition.getProcessingParameters();
                jobProperties.setProperty("input.repository", inputRepository);
                jobProperties.setProperty("output.repository", outputRepository);
                jobProperties.setProperty("input.name", "content.xml");
                jobProperties.setProperty("output.name", "content.xml");
                jobProperties.setProperty("content-type", "application/vnd.oasis.opendocument.chart");
                jobProperties.setProperty("input.datasource-factory", this.dataSourceFactory);
                jobProperties.setProperty("input.master-columns", list);
                jobProperties.setProperty("input.master-values", list2);
                jobProperties.setProperty("input.detail-columns", list3);
                jobProperties.setProperty("ImageService", this.imageService);
                jobProperties.setProperty("MaxRows", this.maxRows);
                pentahoReportEngine.createJob(reportJobDefinition).execute();
            }
            catch (ReportExecutionException reportExecutionException) {
                LOGGER.error((Object)"ReportProcessing failed", (Throwable)reportExecutionException);
            }
            catch (IOException iOException) {
                LOGGER.error((Object)"ReportProcessing failed", (Throwable)iOException);
            }
        }
        catch (IOException iOException) {
            LOGGER.error((Object)"ReportProcessing failed", (Throwable)iOException);
        }
        finally {
            if (inputRepository != null) {
                inputRepository.closeInputRepository();
            }
            if (outputRepository != null) {
                outputRepository.closeOutputRepository();
            }
        }
        return string2;
    }
}

