/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import org.jfree.report.util.Worker;
import org.jfree.report.util.WorkerHandle;

public class WorkerPool {
    private Worker[] workers;
    private boolean workersAvailable;
    private String namePrefix;

    public WorkerPool() {
        this(10);
    }

    public WorkerPool(int n) {
        this(n, "WorkerPool-worker");
    }

    public WorkerPool(int n, String string) {
        if (n <= 0) {
            throw new IllegalArgumentException("Size must be > 0");
        }
        this.workers = new Worker[n];
        this.workersAvailable = true;
        this.namePrefix = string;
    }

    public synchronized boolean isWorkerAvailable() {
        return this.workersAvailable;
    }

    private void updateWorkersAvailable() {
        for (int i = 0; i < this.workers.length; ++i) {
            if (this.workers[i] == null) {
                this.workersAvailable = true;
                return;
            }
            if (!this.workers[i].isAvailable()) continue;
            this.workersAvailable = true;
            return;
        }
        this.workersAvailable = false;
    }

    private synchronized void waitForWorkerAvailable() {
        while (!this.isWorkerAvailable()) {
            try {
                this.wait(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized WorkerHandle getWorkerForWorkload(Runnable runnable) {
        this.waitForWorkerAvailable();
        int n = -1;
        for (int i = 0; i < this.workers.length; ++i) {
            if (this.workers[i] == null) {
                if (n != -1) continue;
                n = i;
                continue;
            }
            if (!this.workers[i].isAvailable()) continue;
            this.workers[i].setWorkload(runnable);
            this.updateWorkersAvailable();
            return new WorkerHandle(this.workers[i]);
        }
        if (n != -1) {
            this.workers[n] = new Worker();
            this.workers[n].setName(this.namePrefix + "-" + n);
            this.workers[n].setWorkerPool(this);
            this.workers[n].setWorkload(runnable);
            this.updateWorkersAvailable();
            return new WorkerHandle(this.workers[n]);
        }
        throw new IllegalStateException("At this point, a worker should already have been assigned.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void workerFinished(Worker worker) {
        if (!worker.isFinish()) {
            throw new IllegalArgumentException("This worker is not in the finish state.");
        }
        for (int i = 0; i < this.workers.length; ++i) {
            if (this.workers[i] != worker) continue;
            WorkerPool workerPool = this;
            synchronized (workerPool) {
                this.workers[i] = null;
                this.workersAvailable = true;
                this.notifyAll();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void workerAvailable(Worker worker) {
        for (int i = 0; i < this.workers.length; ++i) {
            if (this.workers[i] != worker) continue;
            WorkerPool workerPool = this;
            synchronized (workerPool) {
                this.workersAvailable = true;
                this.notifyAll();
            }
            return;
        }
    }

    public void finishAll() {
        for (int i = 0; i < this.workers.length; ++i) {
            if (this.workers[i] == null) continue;
            this.workers[i].finish();
        }
    }
}

