/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report;

import javax.swing.table.TableModel;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportData;

public class TableReportData
implements ReportData {
    private TableModel tableModel;
    private int cursor;
    private int rowMax;
    private int rowMin;
    private int cursorMaxPosition;

    public TableReportData(TableModel tableModel) {
        this(tableModel, 0, tableModel.getRowCount());
    }

    public TableReportData(TableModel tableModel, int n, int n2) {
        this.tableModel = tableModel;
        this.rowMax = n + n2;
        this.rowMin = n;
        this.cursorMaxPosition = n2;
    }

    @Override
    public int getColumnCount() throws DataSourceException {
        return this.tableModel.getColumnCount();
    }

    @Override
    public boolean isReadable() throws DataSourceException {
        return this.cursor > 0 && this.cursor <= this.cursorMaxPosition;
    }

    @Override
    public boolean setCursorPosition(int n) throws DataSourceException {
        if (n > this.cursorMaxPosition) {
            return false;
        }
        if (n < 0) {
            return false;
        }
        this.cursor = n;
        return true;
    }

    @Override
    public boolean isAdvanceable() throws DataSourceException {
        return this.cursor < this.cursorMaxPosition;
    }

    @Override
    public String getColumnName(int n) throws DataSourceException {
        return this.tableModel.getColumnName(n);
    }

    @Override
    public Object get(int n) throws DataSourceException {
        if (!this.isReadable()) {
            throw new DataSourceException("Unable to read from datasource");
        }
        return this.tableModel.getValueAt(this.cursor - 1, n);
    }

    @Override
    public boolean next() throws DataSourceException {
        if (this.cursor >= this.cursorMaxPosition) {
            return false;
        }
        ++this.cursor;
        return true;
    }

    @Override
    public void close() throws DataSourceException {
    }

    @Override
    public int getCursorPosition() throws DataSourceException {
        return this.cursor;
    }
}

