/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.parser.table;

import java.util.ArrayList;
import java.util.List;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Node;
import org.jfree.report.structure.Section;
import org.libreoffice.report.pentaho.model.OfficeTableSection;
import org.libreoffice.report.pentaho.parser.ElementReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.ConditionalPrintExpressionReadHandler;
import org.libreoffice.report.pentaho.parser.table.TableColumnsReadHandler;
import org.libreoffice.report.pentaho.parser.table.TableRowReadHandler;
import org.libreoffice.report.pentaho.parser.table.TableRowsReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TableReadHandler
extends ElementReadHandler {
    private final List<ElementReadHandler> children = new ArrayList<ElementReadHandler>();
    private final Section table = new OfficeTableSection();

    @Override
    protected void startParsing(Attributes attributes) throws SAXException {
        super.startParsing(attributes);
        String string = attributes.getValue("http://openoffice.org/2005/report", "visible");
        if (string == null || "true".equals(string)) {
            this.table.setEnabled(true);
        } else {
            this.table.setEnabled(false);
        }
    }

    protected XmlReadHandler getHandlerForChild(String string, String string2, Attributes attributes) throws SAXException {
        if ("http://openoffice.org/2005/report".equals(string) && "conditional-print-expression".equals(string2)) {
            return new ConditionalPrintExpressionReadHandler((Element)this.table);
        }
        if ("urn:oasis:names:tc:opendocument:xmlns:table:1.0".equals(string)) {
            if ("table-columns".equals(string2) || "table-header-columns".equals(string2)) {
                TableColumnsReadHandler tableColumnsReadHandler = new TableColumnsReadHandler();
                this.children.add(tableColumnsReadHandler);
                return tableColumnsReadHandler;
            }
            if ("table-row".equals(string2)) {
                TableRowReadHandler tableRowReadHandler = new TableRowReadHandler();
                this.children.add(tableRowReadHandler);
                return tableRowReadHandler;
            }
            if ("table-rows".equals(string2) || "table-header-rows".equals(string2)) {
                TableRowsReadHandler tableRowsReadHandler = new TableRowsReadHandler();
                this.children.add(tableRowsReadHandler);
                return tableRowsReadHandler;
            }
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        for (int i = 0; i < this.children.size(); ++i) {
            ElementReadHandler elementReadHandler = this.children.get(i);
            this.table.addNode((Node)elementReadHandler.getElement());
        }
    }

    @Override
    public Element getElement() {
        return this.table;
    }
}

