/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.document;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.drawing.XControlShape;
import com.sun.star.drawing.XShape;
import com.sun.star.drawing.XShapes;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.text.TextContentAnchorType;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.document.FormHandler;

public class Shape {
    public XShape xShape;
    protected FormHandler oFormHandler;
    public XServiceInfo xServiceInfo;
    protected Point aPoint;
    private Size aSize;
    protected XControlShape xControlShape;
    private XMultiServiceFactory xMSF;
    XShapes xShapes;

    public Shape(FormHandler formHandler, Point point, Size size) {
        this.aPoint = point;
        this.aSize = size;
        this.oFormHandler = formHandler;
        this.createShape("com.sun.star.drawing.ControlShape");
    }

    public Shape(FormHandler formHandler, String string, Point point, Size size) {
        try {
            this.aPoint = point;
            this.aSize = size;
            this.oFormHandler = formHandler;
            Object object = this.oFormHandler.xMSF.createInstance(string);
            this.xShapes = (XShapes)UnoRuntime.queryInterface(XShapes.class, (Object)object);
            this.xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Shape() {
    }

    private void createShape(String string) {
        try {
            this.xMSF = this.oFormHandler.xMSFDoc;
            Object object = this.xMSF.createInstance(string);
            this.xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)object);
            this.xShape.setPosition(this.aPoint);
            if (this.aSize != null) {
                this.xShape.setSize(this.aSize);
            } else {
                this.xShape.setSize(new Size(1000, 100));
            }
            Helper.setUnoPropertyValue(this.xShape, "AnchorType", TextContentAnchorType.AT_PARAGRAPH);
            this.xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)this.xShape);
            this.xControlShape = (XControlShape)UnoRuntime.queryInterface(XControlShape.class, (Object)this.xShape);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public Size getSize() {
        return this.xShape.getSize();
    }

    public void setSize(Size size) {
        try {
            this.xShape.setSize(size);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace(System.err);
        }
    }

    public Point getPosition() {
        return this.xShape.getPosition();
    }

    public void setPosition(Point point) {
        this.xShape.setPosition(point);
    }
}

