/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

public class CSVQuoter {
    private char separator;
    private char quate;
    private String doubleQuate;

    public CSVQuoter() {
        this(',', '\"');
    }

    public CSVQuoter(char c) {
        this(c, '\"');
    }

    public CSVQuoter(char c, char c2) {
        this.separator = c;
        this.quate = c2;
        this.doubleQuate = "" + c2 + c2;
    }

    public String doQuoting(String string) {
        if (this.isQuotingNeeded(string)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.quate);
            this.applyQuote(stringBuffer, string);
            stringBuffer.append(this.quate);
            return stringBuffer.toString();
        }
        return string;
    }

    public String undoQuoting(String string) {
        if (this.isQuotingNeeded(string)) {
            int n;
            StringBuffer stringBuffer = new StringBuffer(string.length());
            int n2 = string.length() - 1;
            int n3 = n = 1;
            while (n3 != -1) {
                n3 = string.indexOf(this.doubleQuate, n);
                if (n3 == -1) {
                    stringBuffer.append(string.substring(n, n2));
                    continue;
                }
                stringBuffer.append(string.substring(n, n3));
                n = n3 + 1;
            }
            return stringBuffer.toString();
        }
        return string;
    }

    private boolean isQuotingNeeded(String string) {
        if (string.indexOf(this.separator) != -1) {
            return true;
        }
        if (string.indexOf(10) != -1) {
            return true;
        }
        return string.indexOf(this.quate, 1) != -1;
    }

    private void applyQuote(StringBuffer stringBuffer, String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == this.quate) {
                stringBuffer.append(this.doubleQuate);
                continue;
            }
            stringBuffer.append(c);
        }
    }

    public char getSeparator() {
        return this.separator;
    }

    public char getQuate() {
        return this.quate;
    }
}

